/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryLogicalOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

class TestConstraintNode
extends UnaryLogicalOperatorNode {
    private final String sqlState;
    private final String tableName;
    private final UUID cid;
    private final boolean deferrable;
    private final String constraintName;

    TestConstraintNode(ValueNode valueNode, String string, String string2, ConstraintDescriptor constraintDescriptor, ContextManager contextManager) throws StandardException {
        super(valueNode, constraintDescriptor.deferrable() ? "throwExceptionIfImmediateAndFalse" : "throwExceptionIfFalse", contextManager);
        this.sqlState = string;
        this.tableName = string2;
        this.cid = constraintDescriptor.getUUID();
        this.deferrable = constraintDescriptor.deferrable();
        this.constraintName = constraintDescriptor.getConstraintName();
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        this.bindOperand(fromList, subqueryList, list);
        if (!this.operand.getTypeServices().getTypeId().isBooleanTypeId()) {
            this.operand = new CastNode(this.operand, new DataTypeDescriptor(TypeId.BOOLEAN_ID, true), this.getContextManager());
            ((CastNode)this.operand).bindCastNodeOnly();
        }
        this.setFullTypeInfo();
        return this;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.operand.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.push(this.sqlState);
        methodBuilder.push(this.tableName);
        methodBuilder.push(this.constraintName);
        if (this.deferrable) {
            expressionClassBuilder.pushThisAsActivation(methodBuilder);
            methodBuilder.push(expressionClassBuilder.addItem(this.cid));
            methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.BooleanDataValue", "throwExceptionIfImmediateAndFalse", "org.apache.derby.iapi.types.BooleanDataValue", 5);
        } else {
            methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.BooleanDataValue", "throwExceptionIfFalse", "org.apache.derby.iapi.types.BooleanDataValue", 3);
        }
    }
}

