/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.emf.common.util.Enumerator;

public enum GroupingUnitType implements Enumerator
{
    SECONDS_LITERAL(0, "Seconds", "Seconds"),
    MINUTES_LITERAL(1, "Minutes", "Minutes"),
    HOURS_LITERAL(2, "Hours", "Hours"),
    DAYS_LITERAL(3, "Days", "Days"),
    WEEKS_LITERAL(4, "Weeks", "Weeks"),
    MONTHS_LITERAL(5, "Months", "Months"),
    QUARTERS_LITERAL(6, "Quarters", "Quarters"),
    YEARS_LITERAL(7, "Years", "Years"),
    STRING_LITERAL(8, "String", "String"),
    STRING_PREFIX_LITERAL(9, "StringPrefix", "StringPrefix"),
    WEEK_OF_MONTH_LITERAL(10, "WeekOfMonth", "WeekOfMonth"),
    WEEK_OF_YEAR_LITERAL(11, "WeekOfYear", "WeekOfYear"),
    DAY_OF_WEEK_LITERAL(12, "DayOfWeek", "DayOfWeek"),
    DAY_OF_MONTH_LITERAL(13, "DayOfMonth", "DayOfMonth"),
    DAY_OF_YEAR_LITERAL(14, "DayOfYear", "DayOfYear");

    public static final int SECONDS = 0;
    public static final int MINUTES = 1;
    public static final int HOURS = 2;
    public static final int DAYS = 3;
    public static final int WEEKS = 4;
    public static final int MONTHS = 5;
    public static final int QUARTERS = 6;
    public static final int YEARS = 7;
    public static final int STRING = 8;
    public static final int STRING_PREFIX = 9;
    public static final int WEEK_OF_MONTH = 10;
    public static final int WEEK_OF_YEAR = 11;
    public static final int DAY_OF_WEEK = 12;
    public static final int DAY_OF_MONTH = 13;
    public static final int DAY_OF_YEAR = 14;
    private static final GroupingUnitType[] VALUES_ARRAY;
    public static final List<GroupingUnitType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GroupingUnitType[]{SECONDS_LITERAL, MINUTES_LITERAL, HOURS_LITERAL, DAYS_LITERAL, WEEKS_LITERAL, MONTHS_LITERAL, QUARTERS_LITERAL, YEARS_LITERAL, STRING_LITERAL, STRING_PREFIX_LITERAL, WEEK_OF_MONTH_LITERAL, WEEK_OF_YEAR_LITERAL, DAY_OF_WEEK_LITERAL, DAY_OF_MONTH_LITERAL, DAY_OF_YEAR_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GroupingUnitType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GroupingUnitType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GroupingUnitType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GroupingUnitType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GroupingUnitType get(int value) {
        switch (value) {
            case 0: {
                return SECONDS_LITERAL;
            }
            case 1: {
                return MINUTES_LITERAL;
            }
            case 2: {
                return HOURS_LITERAL;
            }
            case 3: {
                return DAYS_LITERAL;
            }
            case 4: {
                return WEEKS_LITERAL;
            }
            case 5: {
                return MONTHS_LITERAL;
            }
            case 6: {
                return QUARTERS_LITERAL;
            }
            case 7: {
                return YEARS_LITERAL;
            }
            case 8: {
                return STRING_LITERAL;
            }
            case 9: {
                return STRING_PREFIX_LITERAL;
            }
            case 10: {
                return WEEK_OF_MONTH_LITERAL;
            }
            case 11: {
                return WEEK_OF_YEAR_LITERAL;
            }
            case 12: {
                return DAY_OF_WEEK_LITERAL;
            }
            case 13: {
                return DAY_OF_MONTH_LITERAL;
            }
            case 14: {
                return DAY_OF_YEAR_LITERAL;
            }
        }
        return null;
    }

    private GroupingUnitType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static List getGroupingUnits(DataType dataType) {
        if (dataType == DataType.NUMERIC_LITERAL) {
            return null;
        }
        if (dataType == DataType.DATE_TIME_LITERAL) {
            ArrayList<GroupingUnitType> valuesList = new ArrayList<GroupingUnitType>(7);
            int i = 0;
            while (i <= 7) {
                valuesList.add(VALUES_ARRAY[i]);
                ++i;
            }
            return valuesList;
        }
        if (dataType == DataType.TEXT_LITERAL) {
            ArrayList<GroupingUnitType> valuesList = new ArrayList<GroupingUnitType>();
            int i = 8;
            while (i <= 9) {
                valuesList.add(VALUES_ARRAY[i]);
                ++i;
            }
            return valuesList;
        }
        return null;
    }
}

