/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.resource;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.IResourceContentProvider;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntryFilter;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceFilter;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.jface.viewers.Viewer;

public class ResourceFileContentProvider
implements IResourceContentProvider {
    private boolean showFiles;
    private ResourceEntry.Filter filter = new ResourceEntry.Filter(){

        @Override
        public boolean accept(ResourceEntry entity) {
            return true;
        }
    };
    private String[] fileExtension;
    private int showEmptyFolderStatus = 0;

    public ResourceFileContentProvider(final boolean showFiles) {
        this.showFiles = showFiles;
        this.setFilter(new ResourceEntry.Filter(){

            @Override
            public boolean accept(ResourceEntry entity) {
                ResourceEntryFilter filter = new ResourceEntryFilter(ResourceFileContentProvider.this.getResourceFilters());
                if (entity.hasChildren()) {
                    return filter.accept(entity);
                }
                if (showFiles) {
                    return filter.accept(entity);
                }
                if (entity.isFile()) {
                    return false;
                }
                return filter.accept(entity);
            }
        });
    }

    public ResourceFileContentProvider(final String[] extension) {
        this.showFiles = true;
        this.fileExtension = extension;
        this.setFilter(new ResourceEntry.Filter(){

            @Override
            public boolean accept(ResourceEntry entity) {
                ResourceEntryFilter filter = new ResourceEntryFilter(ResourceFileContentProvider.this.getResourceFilters());
                if (entity.hasChildren()) {
                    return filter.accept(entity);
                }
                int i = 0;
                while (i < extension.length) {
                    if (entity.getName().toLowerCase().endsWith(extension[i]) && filter.accept(entity)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        });
    }

    public void setFileNamePattern(final String[] fileNamePattern) {
        this.setFilter(new ResourceEntry.Filter(){

            @Override
            public boolean accept(ResourceEntry entity) {
                ResourceEntryFilter filter = new ResourceEntryFilter(ResourceFileContentProvider.this.getResourceFilters());
                if (entity.hasChildren()) {
                    return filter.accept(entity);
                }
                int i = 0;
                while (i < fileNamePattern.length) {
                    if (entity.getName().toLowerCase().endsWith(fileNamePattern[i].substring(1)) && filter.accept(entity)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        });
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Object[]) {
            return (Object[])parentElement;
        }
        if (parentElement instanceof ResourceEntry) {
            return ((ResourceEntry)parentElement).getChildren(this.filter);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof File) {
            return ((File)element).getParentFile();
        }
        if (element instanceof ResourceEntry) {
            return ((ResourceEntry)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof File) {
            return ((File)element).list() != null && ((File)element).list().length > 0;
        }
        if (element instanceof ResourceEntry) {
            return ((ResourceEntry)element).getChildren(this.filter).length > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setFilter(ResourceEntry.Filter filter) {
        this.filter = filter;
    }

    public ResourceEntry.Filter getFilter() {
        return this.filter;
    }

    @Override
    public int getEmptyFolderShowStatus() {
        return this.showEmptyFolderStatus;
    }

    @Override
    public void setEmptyFolderShowStatus(int showStatus) {
        this.showEmptyFolderStatus = showStatus;
    }

    public ResourceFilter[] getResourceFilters() {
        ResourceFilter[] filters;
        if (this.showEmptyFolderStatus == 1) {
            filters = ReportPlugin.getFilterMap(false).values().toArray(new ResourceFilter[0]);
        } else if (this.showEmptyFolderStatus == 2) {
            ArrayList<ResourceFilter> filterCollection = new ArrayList<ResourceFilter>();
            filterCollection.addAll(ReportPlugin.getFilterMap(false).values());
            ResourceFilter filter = ResourceFilter.generateEmptyFolderFilter();
            filter.setEnabled(true);
            filterCollection.add(filter);
            filters = filterCollection.toArray(new ResourceFilter[0]);
        } else {
            filters = ReportPlugin.getFilterMap().values().toArray(new ResourceFilter[0]);
        }
        return filters;
    }
}

