/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.ppt;

import com.ibm.icu.lang.UCharacter;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.QuotedPrintableCodec;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.ppt.PPTRender;
import org.eclipse.birt.report.engine.emitter.ppt.util.PPTUtil;
import org.eclipse.birt.report.engine.layout.emitter.Image;
import org.eclipse.birt.report.engine.layout.emitter.util.BackgroundImageLayout;
import org.eclipse.birt.report.engine.layout.emitter.util.Position;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;

public class PPTWriter {
    protected static Logger logger = Logger.getLogger(PPTRender.class.getName());
    private PrintWriter writer;
    protected int currentPageNum;
    private int shapeCount;
    protected float pageWidth;
    protected float pageHeight;
    private Map<String, ImageInfo> imageInfos;
    private Map<Integer, List<String>> fileNamesLists;
    private QuotedPrintableCodec quotedPrintableCodec;
    private Stack<ClipArea> clipStack;

    public PPTWriter(OutputStream output) {
        block2: {
            this.writer = null;
            this.currentPageNum = 0;
            this.shapeCount = 0;
            this.imageInfos = new HashMap<String, ImageInfo>();
            this.fileNamesLists = new TreeMap<Integer, List<String>>();
            this.clipStack = new Stack();
            try {
                this.writer = new PrintWriter((Writer)new OutputStreamWriter(output, "UTF-8"), false);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void start(String title, String author, String description, String subject) {
        if (!this.imageInfos.isEmpty()) {
            this.imageInfos.clear();
        }
        if (!this.fileNamesLists.isEmpty()) {
            this.fileNamesLists.clear();
        }
        this.println("MIME-Version: 1.0");
        this.println("Content-Type: multipart/related; boundary=\"___Actuate_Content_Boundary___\"");
        this.println("");
        this.println("--___Actuate_Content_Boundary___");
        this.println("Content-Location: slide-show");
        this.println("Content-Transfer-Encoding: quoted-printable");
        this.println("Content-Type: text/html; charset=\"utf-8\"");
        this.println("");
        this.println("<html");
        this.println("xmlns=3D'http://www.w3.org/TR/REC-html40'");
        this.println("xmlns:o=3D'urn:schemas-microsoft-com:office:office'");
        this.println("xmlns:p=3D'urn:schemas-microsoft-com:office:powerpoint'");
        this.println("xmlns:v=3D'urn:schemas-microsoft-com:vml'");
        this.println(">");
        this.println("<head>");
        this.println("<meta http-equiv=3D'Content-Type' content=3D'text/html; charset=3Dutf-8'>");
        this.println("<meta name=3D'ProgId' content=3D'PowerPoint.Slide'>");
        this.println("<meta name=3D'Generator' content=3D'Actuate View Server'>");
        this.println("<title>" + title + "</title>");
        this.println("<xml><o:DocumentProperties>");
        this.println("<o:Author>" + author + "</o:Author>");
        this.println("<o:Description>" + description + "</o:Description>");
        this.println("<o:Subject>" + subject + "</o:Subject>");
        this.println("</o:DocumentProperties></xml><link rel=3DFile-List href=3D'file-list'>");
        this.println("<link rel=3DPresentation-XML href=3D'presentation'>");
        this.println("</head></body></html>");
    }

    private void print(String text) {
        this.writer.print(text);
    }

    private void println(String text) {
        this.writer.println(text);
    }

    private void print(byte[] data) {
        this.print(new String(data));
    }

    public void end() {
        int slidesizex = (int)Math.ceil(this.pageWidth * 8.0f);
        int slidesizey = (int)Math.ceil(this.pageHeight * 8.0f);
        this.println("--___Actuate_Content_Boundary___");
        this.println("Content-Location: presentation");
        this.println("Content-Transfer-Encoding: quoted-printable");
        this.println("Content-Type: text/xml; charset=\"utf-8\"");
        this.println("");
        this.println("<xml");
        this.println(" xmlns:o=3D'urn:schemas-microsoft-com:office:office'");
        this.println(" xmlns:p=3D'urn:schemas-microsoft-com:office:powerpoint'");
        this.println(">");
        this.println("<p:presentation sizeof=3D'custom' slidesizex=3D'" + slidesizex + "' slidesizey=3D'" + slidesizey + "'>");
        int i = 0;
        while (i < this.currentPageNum) {
            this.println("<p:slide id=3D'" + (i + 1) + "' href=3D's" + (i + 1) + "'/>");
            ++i;
        }
        this.println("</p:presentation></xml>");
        this.println("");
        this.println("--___Actuate_Content_Boundary___");
        this.println("Content-Location: file-list");
        this.println("Content-Transfer-Encoding: quoted-printable");
        this.println("Content-Type: text/xml; charset=\"utf-8\"");
        this.println("<xml");
        this.println(" xmlns:o=3D'urn:schemas-microsoft-com:office:office'");
        this.println(" xmlns:p=3D'urn:schemas-microsoft-com:office:powerpoint'");
        this.println(">");
        this.println("<o:MainFile href=3D'slide-show'/>");
        this.println("<o:File href=3D'presentation'/>");
        this.println("<o:File href=3D'file-list'/>");
        i = 0;
        while (i < this.currentPageNum) {
            this.println("<o:File href=3D's" + (i + 1) + "'/>");
            if (this.fileNamesLists.containsKey(i + 1)) {
                List<String> fileNames = this.fileNamesLists.get(i + 1);
                for (String fileName : fileNames) {
                    this.println("<o:File href=3D\"" + fileName + "\"/>");
                }
            }
            ++i;
        }
        this.println("</xml>");
        this.println("");
        this.println("--___Actuate_Content_Boundary___--");
        this.writer.close();
        this.writer = null;
    }

    public void endPage() {
        try {
            Set<Map.Entry<String, ImageInfo>> entries = this.imageInfos.entrySet();
            for (Map.Entry<String, ImageInfo> entry : entries) {
                ImageInfo info = entry.getValue();
                this.generateImageBytes(info.imageId, info.imageData);
                this.println("\n");
            }
            this.println("</p:slide></body></html>");
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, ioe.getMessage(), ioe);
        }
    }

    private void exportImageHeader(String imagekey) throws IOException {
        this.println("");
        this.println("--___Actuate_Content_Boundary___");
        ImageInfo imageInfo = this.imageInfos.get(imagekey);
        this.println("Content-Location: " + imageInfo.imageName);
        this.println("Content-Transfer-Encoding: base64");
        this.println("Content-Type: image/" + imageInfo.extension + "\n");
    }

    private void generateImageBytes(String imageTitle, byte[] imageData) throws IOException {
        this.exportImageHeader(imageTitle);
        Base64 base = new Base64();
        this.print(base.encode(imageData));
    }

    public void newPage(float pageWidth, float pageHeight, Color backgroundColor) {
        ++this.currentPageNum;
        this.imageInfos.clear();
        if (pageWidth > this.pageWidth) {
            this.pageWidth = pageWidth;
        }
        if (pageHeight > this.pageHeight) {
            this.pageHeight = pageHeight;
        }
        this.println("--___Actuate_Content_Boundary___");
        this.println("Content-Location: s" + this.currentPageNum);
        this.println("Content-Transfer-Encoding: quoted-printable");
        this.println("Content-Type: text/html; charset=\"utf-8\"");
        this.println("");
        this.println("<html");
        this.println(" xmlns=3D'http://www.w3.org/TR/REC-html40'");
        this.println(" xmlns:o=3D'urn:schemas-microsoft-com:office:office'");
        this.println(" xmlns:p=3D'urn:schemas-microsoft-com:office:powerpoint'");
        this.println(" xmlns:v=3D'urn:schemas-microsoft-com:vml'");
        this.println(">");
        this.println("<head/><body><p:slide>");
        this.println("<meta http-equiv=3D'Content-Type' content=3D'text/html; charset=3Dutf-8'>");
        this.drawBackgroundColor(backgroundColor, 0.0, 0.0, pageWidth, pageHeight);
    }

    private String getFontName(BaseFont baseFont) {
        String[][] familyFontNames = baseFont.getFamilyFontName();
        String[] family = familyFontNames[familyFontNames.length - 1];
        return family[family.length - 1];
    }

    public void drawText(String text, float textX, float textY, float width, float height, TextStyle textStyle, PPTUtil.HyperlinkDef link) {
        FontInfo fontInfo = textStyle.getFontInfo();
        Color color = textStyle.getColor();
        boolean rtl = textStyle.isRtl();
        if (fontInfo == null) {
            return;
        }
        float descend = fontInfo.getBaseFont().getFontDescriptor(3, fontInfo.getFontSize());
        BaseFont baseFont = fontInfo.getBaseFont();
        String fontName = this.getFontName(baseFont);
        this.println("<v:shape id=3D\"_x0000_s" + ++this.shapeCount + "\" type=3D\"#_x0000_t202\"");
        this.println(" style=3D'position:absolute;left:" + textX + "pt;top:" + textY + "pt;width:" + width + "pt;height:" + (height += descend * 0.6f) + "pt;v-text-anchor:bottom-baseline;mso-wrap-style:none;'");
        this.println(" filled=3D'f' stroked=3D'f'>");
        this.println("<v:textbox style=3D'mso-fit-shape-to-text:f;' inset=3D'0.00pt 0.00pt 0.00pt 0.00pt'/>");
        this.println("</v:shape>");
        this.println("<div v:shape=3D\"_x0000_s" + this.shapeCount + "\">");
        this.println("<div style=3D'mso-text-indent-alt:0;text-align:left;'><span style=3D'font-family:" + fontName + ";font-size:" + fontInfo.getFontSize() + "pt;color:#" + this.getColorString(color) + ";'" + this.buildI18nAttributes(text, rtl) + ">");
        boolean isItalic = fontInfo != null && (fontInfo.getFontStyle() & 2) != 0;
        boolean isBold = fontInfo != null && (fontInfo.getFontStyle() & 1) != 0;
        boolean isUnderline = textStyle.isUnderline();
        if (isItalic) {
            this.print("<i>");
        }
        if (isBold) {
            this.print("<b>");
        }
        if (isUnderline) {
            this.print("<u>");
        }
        if (link != null) {
            String hyperlink = link.getLink();
            String tooltip = link.getTooltip();
            if (hyperlink != null) {
                hyperlink = this.codeLink(hyperlink);
                this.print("<p:onmouseclick  hyperlinktype=3D\"url\" href=3D\"" + hyperlink + "\"");
                if (tooltip != null) {
                    tooltip = this.codeLink(tooltip);
                    this.print(" tips=3D\"" + tooltip + "\"");
                }
                this.println("/><a href=3D\"" + hyperlink + "/\" target=3D\"_parent\" onclick=3D\"window.event.cancelBubble=3Dtrue;\">");
            }
        }
        this.print(this.getEscapedStr(text));
        if (link != null) {
            this.print("</a>");
        }
        if (isUnderline) {
            this.print("</u>");
        }
        if (isBold) {
            this.print("</b>");
        }
        if (isItalic) {
            this.print("</i>");
        }
        this.println("</span></div>");
        this.println("</div>");
    }

    private String codeLink(String link) {
        try {
            if (this.quotedPrintableCodec == null) {
                this.quotedPrintableCodec = new QuotedPrintableCodec();
            }
            link = this.quotedPrintableCodec.encode(link);
        }
        catch (EncoderException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return link;
    }

    private String getColorString(Color color) {
        StringBuffer buffer = new StringBuffer();
        this.appendComponent(buffer, color.getRed());
        this.appendComponent(buffer, color.getGreen());
        this.appendComponent(buffer, color.getBlue());
        return buffer.toString();
    }

    private void appendComponent(StringBuffer buffer, int component) {
        String hex = Integer.toHexString(component);
        if (hex.length() == 1) {
            buffer.append('0');
        }
        buffer.append(hex);
    }

    public void drawImage(String imageId, byte[] imageData, String extension, float imageX, float imageY, float height, float width, String helpText, PPTUtil.HyperlinkDef link) throws Exception {
        ImageInfo imageInfo = this.getImageInfo(imageId, imageData, extension);
        this.exportImageDefn(imageInfo.imageName, imageInfo.imageId, width, height, imageX, imageY, link);
    }

    private ImageInfo getImageInfo(String imageId, byte[] imageData, String extension) {
        ImageInfo imageInfo = null;
        String imageTitle = this.getImageTitle();
        if (this.imageInfos.containsKey(imageId = imageId != null ? String.valueOf(imageId) + "_" + this.currentPageNum : imageTitle)) {
            imageInfo = this.imageInfos.get(imageId);
        } else {
            String imageName = String.valueOf(imageTitle) + "." + extension;
            imageInfo = new ImageInfo(imageId, imageName, extension, imageData);
            this.imageInfos.put(imageId, imageInfo);
            this.recordFileLists(imageName);
        }
        return imageInfo;
    }

    private void exportImageDefn(String imageName, String imageTitle, double width, double height, double x, double y, PPTUtil.HyperlinkDef link) {
        Crop crop;
        this.println("<v:shape id=3D'" + this.shapeCount + "' type=3D'#_x0000_t75'");
        if (link != null) {
            String hyperlink = link.getLink();
            String tooltip = link.getTooltip();
            if (tooltip != null) {
                tooltip = this.codeLink(tooltip);
                this.print("title=3D\"" + tooltip + "\" ");
            }
            if (hyperlink != null) {
                hyperlink = this.codeLink(hyperlink);
                this.print("href=3D\"" + hyperlink + "\" target=3D\"_parent\"");
            }
        }
        if ((crop = this.checkCrop(x, y, width, height)) == null) {
            this.println(" style=3D'position:absolute;left:" + x + "pt;top:" + y + "pt;width:" + width + "pt;height:" + height + "pt'");
        } else {
            ClipArea clip = this.clipStack.peek();
            double pX = Math.max((double)clip.x, x);
            double pY = Math.max((double)clip.y, y);
            double pWidth = Math.min(x + width, (double)(clip.x + clip.width)) - pX;
            double pHeight = Math.min(y + height, (double)(clip.y + clip.height)) - pY;
            this.println(" style=3D'position:absolute;left:" + pX + "pt;top:" + pY + "pt;width:" + pWidth + "pt;height:" + pHeight + "pt'");
        }
        this.println(" filled=3D'f' stroked=3D'f'>");
        this.print("<v:imagedata src=3D\"" + imageName + "\" o:title=3D\"" + imageTitle + "\"");
        if (crop != null) {
            if (crop.top != 0) {
                this.print(" croptop=3D\"" + crop.top + "f\"");
            }
            if ((double)crop.left != 0.0) {
                this.print(" cropleft=3D\"" + crop.left + "f\"");
            }
            if ((double)crop.right != 0.0) {
                this.print(" cropright=3D\"" + crop.right + "f\"");
            }
            if ((double)crop.bottom != 0.0) {
                this.print(" cropbottom=3D\"" + crop.bottom + "f\"");
            }
        }
        this.println("/>");
        this.println("<o:lock v:ext=3D'edit' aspectratio=3D't'/>");
        this.println("</v:shape>");
    }

    private Crop checkCrop(double x, double y, double width, double height) {
        if (this.clipStack.isEmpty()) {
            return null;
        }
        ClipArea clip = this.clipStack.peek();
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        if (x < (double)clip.x) {
            left = (int)(((double)clip.x - x) * 100.0);
        }
        if (y < (double)clip.y) {
            top = (int)(((double)clip.y - y) * 100.0);
        }
        if (x + width > (double)(clip.x + clip.width)) {
            right = (int)((x + width - (double)(clip.x + clip.width)) * 100.0);
        }
        if (y + height > (double)(clip.y + clip.height)) {
            bottom = (int)((y + height - (double)(clip.y + clip.height)) * 100.0);
        }
        if (left != 0 || right != 0 || top != 0 || bottom != 0) {
            return new Crop(left, right, top, bottom);
        }
        return null;
    }

    private String getImageExtension(String imageURI) {
        String rectifiedImageURI = imageURI.replace('.', '&');
        String extension = imageURI.substring(rectifiedImageURI.lastIndexOf(38) + 1).toLowerCase();
        if (extension.equals("svg")) {
            extension = "jpg";
        }
        return extension;
    }

    private void recordFileLists(String filename) {
        if (this.fileNamesLists.containsKey(this.currentPageNum)) {
            this.fileNamesLists.get(this.currentPageNum).add(filename);
        } else {
            ArrayList<String> fileNames = new ArrayList<String>();
            fileNames.add(filename);
            this.fileNamesLists.put(this.currentPageNum, fileNames);
        }
    }

    public void drawLine(double startX, double startY, double endX, double endY, double width, Color color, int lineStyle) {
        if (color == null || 0.0 == width || lineStyle == 28) {
            return;
        }
        if (lineStyle == 21 || lineStyle == 22 || lineStyle == 20 || lineStyle == 23) {
            this.drawRawLine(startX, startY, endX, endY, width, color, lineStyle);
        } else {
            this.drawRawLine(startX, startY, endX, endY, width, color, 21);
        }
    }

    private void drawRawLine(double startX, double startY, double endX, double endY, double width, Color color, int lineStyle) {
        boolean needflip = false;
        if (endX > startX && endY < startY || endX < startX && endY > startY) {
            needflip = true;
        }
        this.print("<v:line id=3D\"" + ++this.shapeCount + "\"");
        this.print(" style=3D'position:absolute");
        if (needflip) {
            this.print(";flip:y' from=3D\"" + startX + "pt," + endY + "pt\"");
            this.print(" to=3D\"" + endX + "pt," + startY + "pt\"");
        } else {
            this.print("' from=3D\"" + startX + "pt," + startY + "pt\"");
            this.print(" to=3D\"" + endX + "pt," + endY + "pt\"");
        }
        this.print(" strokecolor=3D\"#" + this.getColorString(color) + "\"");
        this.print(" strokeweight=3D\"" + width + "pt\"");
        if (lineStyle == 22) {
            this.println(">");
            this.println("<v:stroke dashstyle=3D\"dash\"/>");
        } else if (lineStyle == 20) {
            this.println(">");
            this.println("<v:stroke dashstyle=3D\"1 1\"/>");
        } else if (lineStyle == 23) {
            this.println(">");
            this.println("<v:stroke linestyle=3D\"thinThin\"/>");
        } else {
            this.println("/>");
            return;
        }
        this.println("</v:line>");
    }

    public void drawBackgroundColor(Color color, double x, double y, double width, double height) {
        if (color == null) {
            return;
        }
        this.print("<v:rect id=3D\"" + ++this.shapeCount + "\"");
        this.print(" style=3D'position:absolute;left:" + x + "pt;top:" + y + "pt;width:" + width + "pt;height:" + height + "pt'");
        this.print(" fillcolor=3D\"#" + this.getColorString(color) + "\"");
        this.println(" stroked=3D\"f\"/>");
    }

    public void drawBackgroundImage(String imageURI, byte[] imageData, float x, float y, float width, float height, float iWidth, float iHeight, float positionX, float positionY, int repeat) {
        if (imageData == null || imageData.length == 0) {
            return;
        }
        float imageWidth = iWidth;
        float imageHeight = iHeight;
        String extension = this.getImageExtension(imageURI);
        try {
            Image image = EmitterUtil.parseImage((byte[])imageData, null, null);
            imageData = image.getData();
            if (imageWidth == 0.0f || imageHeight == 0.0f) {
                imageWidth = image.getWidth();
                imageHeight = image.getHeight();
            }
            ImageInfo imageInfo = this.getImageInfo(imageURI, imageData, extension);
            Position areaPosition = new Position(x, y);
            Position areaSize = new Position(width, height);
            Position imagePosition = new Position(x + positionX, y + positionY);
            Position imageSize = new Position(imageWidth, imageHeight);
            BackgroundImageLayout layout = new BackgroundImageLayout(areaPosition, areaSize, imagePosition, imageSize);
            List positions = layout.getImagePositions(repeat);
            for (Position position : positions) {
                this.exportImageDefn(imageInfo.imageName, imageInfo.imageId, imageWidth, imageHeight, position.getX(), position.getY(), null);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getLocalizedMessage());
        }
    }

    private String getImageTitle() {
        return "slide" + this.currentPageNum + "_image" + ++this.shapeCount;
    }

    protected String getEscapedStr(String s) {
        StringBuffer result = null;
        int spacePos = 1;
        char[] s2char = s.toCharArray();
        int i = 0;
        int max = s2char.length;
        int delta = 0;
        while (i < max) {
            char c = s2char[i];
            String replacement = null;
            if (c == ' ') {
                if (spacePos % 2 != 0 || i == max - 1) {
                    replacement = "&#160;";
                }
                ++spacePos;
            } else {
                spacePos = 0;
            }
            if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd')) {
                replacement = "";
            } else if (c == '&') {
                replacement = "&amp;";
            } else if (c == '<') {
                replacement = "&lt;";
            } else if (c == '>') {
                replacement = "&gt;";
            } else if (c == '\t') {
                replacement = " ";
            } else if (c == '=') {
                replacement = "=3D";
            } else if (c >= '\u0080') {
                replacement = "&#x" + Integer.toHexString(c) + ';';
            }
            if (replacement != null) {
                if (result == null) {
                    result = new StringBuffer(s);
                }
                result.replace(i + delta, i + delta + 1, replacement);
                delta += replacement.length() - 1;
            }
            ++i;
        }
        if (result == null) {
            return s;
        }
        return result.toString();
    }

    private String buildI18nAttributes(String text, boolean rtl) {
        if (text == null) {
            return "";
        }
        if (rtl) {
            int i = text.length();
            while (i-- > 0) {
                UCharacter.UnicodeBlock block = UCharacter.UnicodeBlock.of((int)text.charAt(i));
                if (UCharacter.UnicodeBlock.HEBREW.equals((Object)block)) {
                    return " dir=3D'rtl' lang=3D'HE-IL'";
                }
                if (!UCharacter.UnicodeBlock.ARABIC.equals((Object)block) && !UCharacter.UnicodeBlock.ARABIC_PRESENTATION_FORMS_A.equals((Object)block) && !UCharacter.UnicodeBlock.ARABIC_PRESENTATION_FORMS_B.equals((Object)block) && !UCharacter.UnicodeBlock.ARABIC_SUPPLEMENT.equals((Object)block)) continue;
                return " dir=3D'rtl' lang=3D'AR-DZ'";
            }
            return " dir=3D'rtl' lang=3D'AR-DZ'";
        }
        return " dir=3D'ltr' lang=3D'EN-US'";
    }

    public void clip(float startX, float startY, float width, float height) {
        if (this.clipStack.isEmpty()) {
            this.clipStack.push(new ClipArea(startX, startY, width, height));
        } else {
            ClipArea parent = this.clipStack.peek();
            float newX = Math.max(parent.x, startX);
            float newY = Math.max(parent.y, startY);
            float newWidth = Math.min(startX + width, parent.x + parent.width) - newX;
            float newHeight = Math.min(startY + height, parent.y + parent.height) - newY;
            this.clipStack.push(new ClipArea(newX, newY, newWidth, newHeight));
        }
    }

    public void clipEnd() {
        this.clipStack.pop();
    }

    private class ClipArea {
        float x;
        float y;
        float width;
        float height;

        ClipArea(float x, float y, float width, float height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }

    private class Crop {
        int left;
        int right;
        int top;
        int bottom;

        Crop(int left, int right, int top, int bottom) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }
    }

    private static class ImageInfo {
        public String imageName;
        public String extension;
        public byte[] imageData;
        public String imageId;

        public ImageInfo(String imageId, String imageName, String extension, byte[] imageData) {
            this.imageId = imageId;
            this.imageName = imageName;
            this.extension = extension;
            this.imageData = imageData;
        }
    }
}

