/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.odf;

import com.ibm.icu.util.ULocale;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.odf.AbstractOdfEmitterContext;
import org.eclipse.birt.report.engine.odf.OdfConstants;
import org.eclipse.birt.report.engine.odf.pkg.ImageEntry;
import org.eclipse.birt.report.engine.odf.pkg.Package;
import org.eclipse.birt.report.engine.odf.style.StyleBuilder;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;
import org.eclipse.birt.report.engine.odf.writer.ContentWriter;
import org.eclipse.birt.report.engine.odf.writer.MetaWriter;
import org.eclipse.birt.report.engine.odf.writer.StylesWriter;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public abstract class AbstractOdfEmitter
extends ContentEmitterAdapter
implements OdfConstants {
    protected static Logger logger = Logger.getLogger(AbstractOdfEmitter.class.getName());
    protected static final Set<Integer> NON_INHERITY_STYLES;
    protected IEmitterServices service = null;
    protected OutputStream out = null;
    protected Package pkg;
    protected ByteArrayOutputStream bodyOut = null;
    protected ByteArrayOutputStream masterPageOut = null;
    protected ContentEmitterVisitor contentVisitor = new ContentEmitterVisitor((IContentEmitter)this);
    protected AbstractOdfEmitterContext context = null;
    protected IReportContext reportContext;
    protected IReportContent reportContent;
    protected IReportRunnable reportRunnable;
    protected IHTMLActionHandler actionHandler;
    protected int tableCount;

    static {
        HashSet<Integer> nonInherityStyles = new HashSet<Integer>();
        nonInherityStyles.add(15);
        nonInherityStyles.add(22);
        nonInherityStyles.add(11);
        nonInherityStyles.add(13);
        nonInherityStyles.add(49);
        nonInherityStyles.add(41);
        nonInherityStyles.add(46);
        nonInherityStyles.add(52);
        nonInherityStyles.add(42);
        nonInherityStyles.add(14);
        nonInherityStyles.add(21);
        nonInherityStyles.add(10);
        NON_INHERITY_STYLES = Collections.unmodifiableSet(nonInherityStyles);
    }

    protected AbstractOdfEmitter() {
    }

    public void initialize(IEmitterServices service) throws EngineException {
        this.service = service;
        this.context = this.createContext();
        if (service != null) {
            this.reportRunnable = service.getReportRunnable();
            this.actionHandler = (IHTMLActionHandler)service.getOption("actionHandler");
            String tempFileDir = service.getReportEngine().getConfig().getTempDir();
            this.context.setTempFileDir(service.getReportEngine().getConfig().getTempDir());
            this.bodyOut = new ByteArrayOutputStream();
            this.masterPageOut = new ByteArrayOutputStream();
            this.out = EmitterUtil.getOuputStream((IEmitterServices)service, (String)("report." + this.getOutputFormat()));
            this.pkg = Package.createInstance(this.out, tempFileDir, this.getRootMime());
            this.context.setPackage(this.pkg);
            this.reportContext = service.getReportContext();
        }
        ULocale locale = null;
        if (this.reportContext != null) {
            locale = ULocale.forLocale((Locale)this.reportContext.getLocale());
        }
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        this.context.setLocale(locale);
    }

    public void start(IReportContent report) throws BirtException {
        super.start(report);
        Object dpi = report.getReportContext().getRenderOption().getOption("RenderDpi");
        int renderDpi = 0;
        if (dpi != null && dpi instanceof Integer) {
            renderDpi = (Integer)dpi;
        }
        int reportDpi = PropertyUtil.getRenderDpi((IReportContent)report, (int)renderDpi);
        this.context.setReportDpi(reportDpi);
        this.reportContent = report;
    }

    public void end(IReportContent report) throws BirtException {
        this.save();
    }

    private void save() {
        try {
            ContentWriter docContentWriter = new ContentWriter(this.pkg.addEntry("content.xml", "text/xml").getOutputStream(), this.context.getReportDpi());
            docContentWriter.write(this.context.getStyleManager().getStyles(), new ByteArrayInputStream(this.bodyOut.toByteArray()));
            StylesWriter stylesWriter = new StylesWriter(this.pkg.addEntry("styles.xml", "text/xml").getOutputStream(), this.context.getReportDpi());
            stylesWriter.start();
            stylesWriter.writeStyles(this.context.getGlobalStyleManager().getStyles());
            stylesWriter.writeMasterPage(new ByteArrayInputStream(this.masterPageOut.toByteArray()));
            stylesWriter.end();
            this.pkg.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    protected abstract AbstractOdfEmitterContext createContext();

    protected void writeMetaProperties(IReportContent reportContent) throws IOException, BirtException {
        String creator = null;
        String title = null;
        String subject = null;
        String description = null;
        if (reportContent != null) {
            ReportDesignHandle designHandle = reportContent.getDesign().getReportDesign();
            creator = designHandle.getAuthor();
            title = reportContent.getTitle();
            subject = designHandle.getSubject();
            description = designHandle.getDescription();
        }
        MetaWriter writer = new MetaWriter(this.pkg.addEntry("meta.xml", "text/xml").getOutputStream());
        writer.start();
        writer.writeMeta(creator, title, description, subject);
        writer.end();
    }

    protected StyleEntry[] getColStyles(double[] cols) {
        StyleEntry[] styles = new StyleEntry[cols.length];
        StyleEntry previousStyle = null;
        int i = 0;
        while (i < cols.length) {
            StyleEntry style = null;
            if (previousStyle != null && previousStyle.getDoubleProperty(35) != null && Math.abs(previousStyle.getDoubleProperty(35) - cols[i]) < 1.0E-4) {
                style = previousStyle;
            } else {
                style = StyleBuilder.createEmptyStyleEntry(3);
                style.setProperty(35, cols[i]);
                this.context.addStyle(this.getTableStylePrefix(), style);
                previousStyle = style;
            }
            styles[i] = style;
            ++i;
        }
        return styles;
    }

    protected abstract String getRootMime();

    protected String getTableStylePrefix() {
        return "Table" + this.tableCount + ".";
    }

    protected void processBackgroundImageStyle(StyleEntry style) {
        if (style == null) {
            return;
        }
        String imageUri = EmitterUtil.getBackgroundImageUrl((IStyle)style.getStyle(), (ReportDesignHandle)this.reportContent.getDesign().getReportDesign(), (Map)this.reportContext.getAppContext());
        if (imageUri != null) {
            try {
                ImageEntry entry = this.context.getImageManager().addImage(imageUri, null, null);
                style.setProperty(51, entry.getUri());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage());
            }
        }
    }

    protected StyleEntry makePageLayoutStyle(IPageContent page) {
        StyleEntry pageLayout = StyleBuilder.createStyleEntry(page.getComputedStyle(), 6);
        pageLayout.setProperty(35, page.getPageWidth());
        pageLayout.setProperty(36, page.getPageHeight());
        pageLayout.setProperty(49, page.getFooterHeight());
        pageLayout.setProperty(48, page.getHeaderHeight());
        pageLayout.setProperty(42, page.getMarginTop());
        pageLayout.setProperty(43, page.getMarginBottom());
        pageLayout.setProperty(44, page.getMarginLeft());
        pageLayout.setProperty(45, page.getMarginRight());
        pageLayout.setProperty(50, page.getOrientation());
        IStyle style = page.getComputedStyle();
        pageLayout.setProperty(52, style.getBackgroundWidth());
        pageLayout.setProperty(53, style.getBackgroundHeight());
        pageLayout.setProperty(54, style.getBackgroundPositionX());
        pageLayout.setProperty(55, style.getBackgroundPositionY());
        pageLayout.setProperty(56, style.getBackgroundRepeat());
        this.processBackgroundImageStyle(pageLayout);
        this.context.addGlobalStyle(pageLayout);
        return pageLayout;
    }
}

