/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.index.v2;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.impl.BookmarkContent;
import org.eclipse.birt.report.engine.internal.index.v2.BTreeMap;
import org.eclipse.birt.report.engine.internal.index.v2.IndexConstants;

public class IndexWriter
implements IndexConstants {
    public static int MAX_INLINE_INDEX_ENTRY = 10000;
    IDocArchiveWriter archive;
    String name;
    int type;
    HashMap<String, Object> inlineMap;
    BTreeMap btree;
    int entrySize;

    public IndexWriter(IDocArchiveWriter archive, String name) {
        this.archive = archive;
        this.name = name;
    }

    void add(String key, long value) throws IOException {
        if (this.inlineMap == null) {
            this.type = 1;
            this.inlineMap = new HashMap();
        }
        if (this.inlineMap.size() >= MAX_INLINE_INDEX_ENTRY) {
            this.flushBtree();
            this.inlineMap.clear();
        }
        if (!this.inlineMap.containsKey(key)) {
            this.inlineMap.put(key, value);
            ++this.entrySize;
        }
    }

    void add(String bookmark, BookmarkContent info) throws IOException {
        if (this.inlineMap == null) {
            this.type = 2;
            this.inlineMap = new HashMap();
        }
        if (this.inlineMap.size() >= MAX_INLINE_INDEX_ENTRY) {
            this.flushBtree();
            this.inlineMap.clear();
        }
        if (!this.inlineMap.containsKey(bookmark)) {
            this.inlineMap.put(bookmark, info);
            ++this.entrySize;
        }
    }

    void close() throws IOException {
        if (this.btree == null) {
            RAOutputStream stream = this.archive.createOutputStream(this.name);
            try {
                DataOutputStream output = new DataOutputStream((OutputStream)stream);
                if (this.type == 1) {
                    IOUtil.writeInt((OutputStream)output, (int)0);
                    IOUtil.writeInt((OutputStream)output, (int)1);
                    IOUtil.writeInt((OutputStream)output, (int)this.inlineMap.size());
                    for (Map.Entry<String, Object> entry : this.inlineMap.entrySet()) {
                        IOUtil.writeString((DataOutputStream)output, (String)entry.getKey());
                        IOUtil.writeLong((DataOutputStream)output, (long)((Long)entry.getValue()));
                    }
                } else if (this.type == 2) {
                    IOUtil.writeInt((OutputStream)output, (int)1);
                    IOUtil.writeInt((OutputStream)output, (int)1);
                    IOUtil.writeInt((OutputStream)output, (int)this.inlineMap.size());
                    for (Map.Entry<String, Object> entry : this.inlineMap.entrySet()) {
                        IOUtil.writeString((DataOutputStream)output, (String)entry.getKey());
                        ((BookmarkContent)entry.getValue()).writeStream(output);
                    }
                }
                this.inlineMap.clear();
            }
            finally {
                stream.close();
            }
        }
        if (this.btree != null) {
            this.flushBtree();
            this.btree.close();
        }
    }

    protected void flushBtree() throws IOException {
        if (this.btree == null) {
            this.btree = BTreeMap.createTreeMap(this.archive, this.name, this.type);
        }
        ArrayList<Map.Entry<String, Object>> entries = new ArrayList<Map.Entry<String, Object>>(this.inlineMap.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        for (Map.Entry<String, Object> entry : entries) {
            this.btree.insert(entry.getKey(), entry.getValue());
        }
    }
}

