/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import java.lang.reflect.Method;
import java.util.Collection;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.api.script.eventadapter.ReportEventAdapter;
import org.eclipse.birt.report.engine.api.script.eventhandler.IReportEventHandler;
import org.eclipse.birt.report.engine.api.script.instance.IPageInstance;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.impl.PageContent;
import org.eclipse.birt.report.engine.executor.EventHandlerManager;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.ReportDesign;
import org.eclipse.birt.report.engine.script.internal.instance.PageInstance;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.simpleapi.IDesignElement;
import org.eclipse.birt.report.model.api.simpleapi.SimpleElementFactory;

public class ReportScriptExecutor
extends ScriptExecutor {
    public static void handleOnPrepare(ReportDesignHandle report, ExecutionContext context) {
        try {
            String scriptText = report.getOnPrepare();
            Expression.Script scriptExpr = null;
            if (scriptText != null) {
                String id = ModuleUtil.getScriptUID((Object)report.getPropertyHandle("onPrepare"));
                scriptExpr = Expression.newScript(scriptText);
                scriptExpr.setFileName(id);
            }
            if (ReportScriptExecutor.handleScript(null, scriptExpr, context).didRun()) {
                return;
            }
            IReportEventHandler eh = (IReportEventHandler)ReportScriptExecutor.getInstance((DesignElementHandle)report, context);
            if (eh != null) {
                eh.onPrepare(context.getReportContext());
            }
        }
        catch (Exception e) {
            ReportScriptExecutor.addException(context, e, (DesignElementHandle)report);
        }
    }

    public static void handleInitialize(ModuleHandle design, ExecutionContext context) {
        try {
            String scriptText = design.getInitialize();
            Expression.Script scriptExpr = null;
            if (scriptText != null) {
                String id = ModuleUtil.getScriptUID((Object)design.getPropertyHandle("initialize"));
                scriptExpr = Expression.newScript(scriptText);
                scriptExpr.setFileName(id);
            }
            if (ReportScriptExecutor.handleScript(null, scriptExpr, context).didRun()) {
                return;
            }
            IReportEventHandler eh = (IReportEventHandler)ReportScriptExecutor.getInstance((DesignElementHandle)design, context);
            if (eh != null) {
                eh.initialize(context.getReportContext());
            }
        }
        catch (Exception e) {
            ReportScriptExecutor.addException(context, e, (DesignElementHandle)design);
        }
    }

    public static void handleBeforeFactory(ReportDesignHandle report, ExecutionContext context) {
        try {
            IDesignElement element = SimpleElementFactory.getInstance().getElement((DesignElementHandle)report);
            ReportDesign reportDesign = new ReportDesign(report);
            String scriptText = report.getBeforeFactory();
            Expression.Script scriptExpr = null;
            if (scriptText != null) {
                String id = ModuleUtil.getScriptUID((Object)report.getPropertyHandle("beforeFactory"));
                scriptExpr = Expression.newScript(scriptText);
                scriptExpr.setFileName(id);
            }
            if (ReportScriptExecutor.handleScript(element, scriptExpr, context).didRun()) {
                return;
            }
            IReportEventHandler eh = (IReportEventHandler)ReportScriptExecutor.getInstance((DesignElementHandle)report, context);
            if (eh != null) {
                eh.beforeFactory(reportDesign, context.getReportContext());
            }
        }
        catch (Exception e) {
            ReportScriptExecutor.addException(context, e, (DesignElementHandle)report);
        }
    }

    public static void handleAfterFactory(ReportDesignHandle report, ExecutionContext context) {
        try {
            String scriptText = report.getAfterFactory();
            Expression.Script scriptExpr = null;
            if (scriptText != null) {
                String id = ModuleUtil.getScriptUID((Object)report.getPropertyHandle("afterFactory"));
                scriptExpr = Expression.newScript(scriptText);
                scriptExpr.setFileName(id);
            }
            if (ReportScriptExecutor.handleScript(null, scriptExpr, context).didRun()) {
                return;
            }
            IReportEventHandler eh = (IReportEventHandler)ReportScriptExecutor.getInstance((DesignElementHandle)report, context);
            if (eh != null) {
                eh.afterFactory(context.getReportContext());
            }
        }
        catch (Exception e) {
            ReportScriptExecutor.addException(context, e, (DesignElementHandle)report);
        }
    }

    public static void handleBeforeRender(ReportDesignHandle report, ExecutionContext context) {
        try {
            String scriptText = report.getBeforeRender();
            Expression.Script scriptExpr = null;
            if (scriptText != null) {
                String id = ModuleUtil.getScriptUID((Object)report.getPropertyHandle("beforeRender"));
                scriptExpr = Expression.newScript(scriptText);
                scriptExpr.setFileName(id);
            }
            if (ReportScriptExecutor.handleScript(null, scriptExpr, context).didRun()) {
                return;
            }
            IReportEventHandler eh = (IReportEventHandler)ReportScriptExecutor.getInstance((DesignElementHandle)report, context);
            if (eh != null) {
                eh.beforeRender(context.getReportContext());
            }
        }
        catch (Exception e) {
            ReportScriptExecutor.addException(context, e, (DesignElementHandle)report);
        }
    }

    public static void handleAfterRender(ReportDesignHandle report, ExecutionContext context) {
        try {
            String scriptText = report.getAfterRender();
            Expression.Script scriptExpr = null;
            if (scriptText != null) {
                String id = ModuleUtil.getScriptUID((Object)report.getPropertyHandle("afterRender"));
                scriptExpr = Expression.newScript(scriptText);
                scriptExpr.setFileName(id);
            }
            if (ReportScriptExecutor.handleScript(null, scriptExpr, context).didRun()) {
                return;
            }
            IReportEventHandler eh = (IReportEventHandler)ReportScriptExecutor.getInstance((DesignElementHandle)report, context);
            if (eh != null) {
                eh.afterRender(context.getReportContext());
            }
        }
        catch (Exception e) {
            ReportScriptExecutor.addException(context, e, (DesignElementHandle)report);
        }
    }

    public static void handleOnPageEndScript(Report report, ExecutionContext context, PageContent pageContent, Collection<IContent> contents) {
        try {
            if (!ReportScriptExecutor.needOnPageEnd(report)) {
                return;
            }
            PageInstance pageInstance = new PageInstance(context, pageContent, contents);
            if (ReportScriptExecutor.handleScript(pageInstance, report.getOnPageEnd(), context).didRun()) {
                return;
            }
            IReportEventHandler eh = ReportScriptExecutor.getEventHandler(report, context);
            if (eh != null) {
                eh.onPageEnd(pageInstance, context.getReportContext());
            }
        }
        catch (Exception e) {
            ReportScriptExecutor.addException(context, e, (DesignElementHandle)report.getReportDesign());
        }
    }

    public static void handleOnPageStartScript(Report report, ExecutionContext context, PageContent pageContent, Collection<IContent> contents) {
        try {
            if (!ReportScriptExecutor.needOnPageStart(report)) {
                return;
            }
            PageInstance pageInstance = new PageInstance(context, pageContent, contents);
            if (ReportScriptExecutor.handleScript(pageInstance, report.getOnPageStart(), context).didRun()) {
                return;
            }
            IReportEventHandler eh = ReportScriptExecutor.getEventHandler(report, context);
            if (eh != null) {
                eh.onPageStart(pageInstance, context.getReportContext());
            }
        }
        catch (Exception e) {
            ReportScriptExecutor.addException(context, e, (DesignElementHandle)report.getReportDesign());
        }
    }

    private static boolean needOnPageStart(Report report) {
        return report.getOnPageStart() != null || report.getJavaClass() != null;
    }

    private static boolean needOnPageEnd(Report report) {
        return report.getOnPageEnd() != null || report.getJavaClass() != null;
    }

    private static IReportEventHandler getEventHandler(Report report, ExecutionContext context) {
        try {
            return (IReportEventHandler)ReportScriptExecutor.getInstance(report.getJavaClass(), context);
        }
        catch (ClassCastException e) {
            ReportScriptExecutor.addClassCastException(context, e, (DesignElementHandle)report.getReportDesign(), IReportEventHandler.class);
        }
        catch (EngineException e) {
            ReportScriptExecutor.addException(context, (Exception)((Object)e), (DesignElementHandle)report.getReportDesign());
        }
        return null;
    }

    public static boolean existPageScript(Report report, ExecutionContext context) {
        String javaClass = report.getJavaClass();
        if (javaClass == null) {
            return false;
        }
        Class clazz = null;
        try {
            clazz = EventHandlerManager.loadClass(javaClass, context);
            return ReportScriptExecutor.checkPageScriptMethod("onPageStart", clazz, IReportEventHandler.class, IPageInstance.class, ReportEventAdapter.class) || ReportScriptExecutor.checkPageScriptMethod("onPageEnd", clazz, IReportEventHandler.class, IPageInstance.class, ReportEventAdapter.class);
        }
        catch (EngineException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected static boolean checkPageScriptMethod(String methodName, Class<?> clazz, Class<?> handler, Class<?> instance, Class<?> adapter) {
        if (!handler.isAssignableFrom(clazz)) {
            return false;
        }
        try {
            Method method = clazz.getMethod(methodName, instance, IReportContext.class);
            return method.getDeclaringClass() != adapter;
        }
        catch (SecurityException securityException) {
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }
}

