/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.net.URL;
import java.util.Map;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.core.DesignSessionImpl;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.parser.LibraryState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ReportState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.XMLParserHandler;

class GenericModuleParserHandlerImpl
extends ModuleParserHandler {
    protected URL location = null;
    protected URL systemID = null;
    protected ModuleOption options = null;

    GenericModuleParserHandlerImpl(DesignSessionImpl theSession, URL systemID, String fileName, ModuleOption options) {
        super(theSession, fileName);
        this.systemID = systemID;
        this.fileName = fileName;
        this.options = options;
        this.location = ModelUtil.getURLPresentation(fileName);
    }

    GenericModuleParserHandlerImpl(DesignSessionImpl theSession, URL systemID, String fileName, ModuleOption options, Map<String, Library> reloadLibs) {
        super(theSession, fileName, reloadLibs);
        this.systemID = systemID;
        this.fileName = fileName;
        this.options = options;
    }

    @Override
    public AbstractParseState createStartState() {
        return new StartState();
    }

    class StartState
    extends XMLParserHandler.InnerParseState {
        StartState() {
        }

        @Override
        public AbstractParseState startElement(String tagName) {
            if ("report".equalsIgnoreCase(tagName)) {
                GenericModuleParserHandlerImpl.this.module = new ReportDesign(GenericModuleParserHandlerImpl.this.session);
                GenericModuleParserHandlerImpl.this.module.setSystemId(GenericModuleParserHandlerImpl.this.systemID);
                GenericModuleParserHandlerImpl.this.module.setFileName(GenericModuleParserHandlerImpl.this.fileName);
                GenericModuleParserHandlerImpl.this.module.setOptions(GenericModuleParserHandlerImpl.this.options);
                GenericModuleParserHandlerImpl.this.module.setLocation(GenericModuleParserHandlerImpl.this.location);
                GenericModuleParserHandlerImpl.this.buildModuleOptions(GenericModuleParserHandlerImpl.this.options);
                if (GenericModuleParserHandlerImpl.this.markLineNumber) {
                    GenericModuleParserHandlerImpl.this.tempLineNumbers.put(GenericModuleParserHandlerImpl.this.module, GenericModuleParserHandlerImpl.this.locator.getLineNumber());
                }
                return new ReportState(GenericModuleParserHandlerImpl.this);
            }
            if ("library".equalsIgnoreCase(tagName)) {
                GenericModuleParserHandlerImpl.this.module = new Library(GenericModuleParserHandlerImpl.this.session);
                GenericModuleParserHandlerImpl.this.module.setSystemId(GenericModuleParserHandlerImpl.this.systemID);
                GenericModuleParserHandlerImpl.this.module.setFileName(GenericModuleParserHandlerImpl.this.fileName);
                GenericModuleParserHandlerImpl.this.module.setLocation(GenericModuleParserHandlerImpl.this.location);
                GenericModuleParserHandlerImpl.this.module.setOptions(GenericModuleParserHandlerImpl.this.options);
                GenericModuleParserHandlerImpl.this.buildModuleOptions(GenericModuleParserHandlerImpl.this.options);
                if (GenericModuleParserHandlerImpl.this.markLineNumber) {
                    GenericModuleParserHandlerImpl.this.tempLineNumbers.put(GenericModuleParserHandlerImpl.this.module, GenericModuleParserHandlerImpl.this.locator.getLineNumber());
                }
                return new LibraryState(GenericModuleParserHandlerImpl.this);
            }
            return super.startElement(tagName);
        }
    }
}

