/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.apache.ode.deploy.ui.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.bpel.apache.ode.deploy.model.dd.DocumentRoot;
import org.eclipse.bpel.apache.ode.deploy.model.dd.ProcessType;
import org.eclipse.bpel.apache.ode.deploy.model.dd.TDeployment;
import org.eclipse.bpel.apache.ode.deploy.model.dd.ddFactory;
import org.eclipse.bpel.apache.ode.deploy.model.dd.util.ddResourceFactoryImpl;
import org.eclipse.bpel.apache.ode.deploy.model.dd.util.ddResourceImpl;
import org.eclipse.bpel.apache.ode.deploy.ui.messages.ODEDeployUIMessages;
import org.eclipse.bpel.apache.ode.deploy.ui.util.DeployUtils;
import org.eclipse.bpel.apache.ode.deploy.ui.wizards.ODEDeployWizardPage;
import org.eclipse.bpel.model.Process;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewODEDeployWizard
extends Wizard
implements INewWizard {
    private ODEDeployWizardPage page;
    private ISelection selection;

    public NewODEDeployWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new ODEDeployWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewODEDeployWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            Resource emfResource = this.createBaseDeploymentDescriptor(file);
            emfResource.save(null);
        }
        catch (IOException e) {
            this.throwCoreException(e.getMessage());
        }
        monitor.worked(1);
        monitor.setTaskName(ODEDeployUIMessages.NewODEDeployWizard_Task_Running);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"org.eclipse.bpel.apache.ode.deploy.ui.editors.ODEDeployMultiPageEditor", (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    public Resource createBaseDeploymentDescriptor(IFile file) {
        URI fileURI = URI.createURI((String)file.getFullPath().toString());
        ddResourceFactoryImpl fac = new ddResourceFactoryImpl();
        ddResourceImpl ddResource = (ddResourceImpl)fac.createResource(fileURI);
        ddResource.setEncoding("UTF-8");
        DocumentRoot rootElm = ddFactory.eINSTANCE.createDocumentRoot();
        TDeployment deployElement = ddFactory.eINSTANCE.createTDeployment();
        rootElm.setDeploy(deployElement);
        ddResource.getContents().add((Object)rootElm);
        IProject project = file.getProject();
        List<Process> processes = DeployUtils.loadAllBPELFromProject(project, (ResourceSet)new ResourceSetImpl());
        for (Process process : processes) {
            ProcessType pt = DeployUtils.createProcessStub(process);
            pt.setActive(true);
            pt.setRetired(false);
            pt.setModel(process);
            deployElement.getProcess().add((Object)pt);
        }
        return ddResource;
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.bpel.apache.ode.deploy.ui", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

