/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.runtimes.facets;

import java.util.HashMap;
import org.eclipse.bpel.runtimes.facets.BPELVirtualComponent;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jst.common.project.facet.WtpUtils;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class BPELCoreFacetInstallDelegate
implements IDelegate {
    public void execute(IProject proj, IProjectFacetVersion ver, Object obj, IProgressMonitor progMon) throws CoreException {
        progMon.beginTask("Configuring ...", 300);
        IDataModel model = (IDataModel)obj;
        String contentRoot = (String)model.getProperty("BPELFacetInstallDataModelProvider.contentRoot");
        contentRoot = contentRoot == null || "".equals(contentRoot) ? "bpelContent" : contentRoot;
        WtpUtils.addNatures((IProject)proj);
        IFolder bpelContent = proj.getFolder(contentRoot);
        if (!bpelContent.exists()) {
            bpelContent.create(true, true, null);
        }
        BPELVirtualComponent factory = new BPELVirtualComponent();
        IVirtualComponent newComponent = factory.createComponent(proj);
        newComponent.create(0, null);
        progMon.worked(100);
        newComponent.getRootFolder().createLink((IPath)new Path("/" + contentRoot), 0, null);
        progMon.worked(100);
        this.addBuilder(proj, (IProgressMonitor)new SubProgressMonitor(progMon, 100));
        progMon.done();
    }

    protected void addBuilder(IProject proj, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String builderName = "org.eclipse.bpel.validator.builder";
        ICommand buildCommand = description.newCommand();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("debug", "false");
        buildCommand.setArguments(args);
        buildCommand.setBuilderName(builderName);
        ICommand[] commands = description.getBuildSpec();
        if (commands == null) {
            description.setBuildSpec(new ICommand[]{buildCommand});
            proj.setDescription(description, 2, monitor);
        } else {
            boolean bFound = false;
            ICommand[] iCommandArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                ICommand c = iCommandArray[n2];
                if (builderName.equals(c.getBuilderName())) {
                    bFound = true;
                    break;
                }
                ++n2;
            }
            if (!bFound) {
                int i = commands.length;
                ICommand[] newCommands = new ICommand[i + 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                newCommands[i] = buildCommand;
                description.setBuildSpec(newCommands);
                proj.setDescription(description, 2, monitor);
            }
        }
    }
}

