/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui;

import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.bpel.common.ui.ColorUtils;
import org.eclipse.bpel.ui.BPELResourceChangeListener;
import org.eclipse.bpel.ui.IBPELUIConstants;
import org.eclipse.bpel.ui.Templates;
import org.eclipse.bpel.ui.expressions.Functions;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class BPELUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.bpel.ui";
    public static BPELUIPlugin INSTANCE;
    private ColorRegistry colorRegistry;
    protected boolean imagesAndColorsInitialized;
    private BPELResourceChangeListener resourceChangeListener;
    private ISaveParticipant saveParticipant;
    private Templates mTemplates;

    public URI getURI(String path) {
        return URI.createPlatformPluginURI((String)(String.valueOf(this.getID()) + path), (boolean)false);
    }

    public static Image createImage(String relativeLocation) {
        Image result = null;
        try {
            ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)relativeLocation);
            result = desc.createImage();
        }
        catch (Exception e) {
            BPELUIPlugin.log(e, 2);
        }
        return result;
    }

    public String getDefaultPage() {
        return this.getPreferenceStore().getString("org.eclipse.bpel.ui.bpeleditor.defaultpage");
    }

    public void setDefaultPage(String page) {
        this.getPreferenceStore().setValue("org.eclipse.bpel.ui.bpeleditor.defaultpage", page);
    }

    private void createImageDescriptor(String id, URL baseURL) {
        URL url = null;
        try {
            url = new URL(baseURL, "icons/" + id);
        }
        catch (MalformedURLException e) {
            BPELUIPlugin.log(e);
        }
        ImageDescriptor desc = ImageDescriptor.createFromURL(url);
        this.getImageRegistry().put(id, desc);
    }

    public ImageDescriptor getImageDescriptor(String id) {
        return this.getImageRegistry().getDescriptor(id);
    }

    public Image getImage(String id) {
        return this.getImageRegistry().get(id);
    }

    public String getID() {
        return this.getBundle().getSymbolicName();
    }

    private void initializeColors() {
        this.colorRegistry = new ColorRegistry();
        RGB color_240_240_240 = ColorUtils.getRelativeRGB((int)240, (int)240, (int)240);
        RGB color_255_255_255 = ColorUtils.getRelativeRGB((int)255, (int)255, (int)255);
        this.colorRegistry.put("flowBorder", ColorUtils.getRelativeRGB((int)112, (int)152, (int)224));
        this.colorRegistry.put("gradientFrom", color_255_255_255);
        this.colorRegistry.put("gradientTo", color_240_240_240);
        if (ColorUtils.isInvertedColorScheme()) {
            this.colorRegistry.put("activityBorder", ColorUtils.getRelativeRGB((int)25, (int)25, (int)25));
            this.colorRegistry.put("compositeActivityBorder", ColorUtils.getRelativeRGB((int)25, (int)25, (int)25));
            this.colorRegistry.put("scopeActivityBorder", ColorUtils.getRelativeRGB((int)25, (int)25, (int)25));
            this.colorRegistry.put("implicitLink", ColorUtils.getRelativeRGB((int)25, (int)25, (int)25));
        } else {
            this.colorRegistry.put("activityBorder", ColorUtils.getRelativeRGB((int)176, (int)176, (int)176));
            this.colorRegistry.put("compositeActivityBorder", ColorUtils.getRelativeRGB((int)205, (int)205, (int)205));
            this.colorRegistry.put("scopeActivityBorder", ColorUtils.getRelativeRGB((int)205, (int)205, (int)205));
            this.colorRegistry.put("implicitLink", ColorUtils.getRelativeRGB((int)200, (int)200, (int)200));
        }
        this.colorRegistry.put("hilightNode", ColorUtils.getRelativeRGB((int)255, (int)255, (int)0));
        this.colorRegistry.put("variableBackground", ColorUtils.getRelativeRGB((int)255, (int)255, (int)255));
        this.colorRegistry.put("variableSeparator", ColorUtils.getRelativeRGB((int)230, (int)230, (int)230));
        this.colorRegistry.put("variableReference", ColorUtils.getRelativeRGB((int)99, (int)151, (int)245));
        this.colorRegistry.put("linkOne", ColorUtils.getRelativeRGB((int)238, (int)197, (int)253));
        this.colorRegistry.put("linkTwo", ColorUtils.getRelativeRGB((int)73, (int)0, (int)107));
        this.colorRegistry.put("linkThree", ColorUtils.getRelativeRGB((int)222, (int)144, (int)254));
        this.colorRegistry.put("COLOR_WHITE", ColorUtils.getRelativeRGB((int)255, (int)255, (int)255));
        this.colorRegistry.put("COLOR_BLACK", ColorUtils.getRelativeRGB((int)0, (int)0, (int)0));
        this.colorRegistry.put("COLOR_RED", ColorUtils.getRelativeRGB((int)255, (int)0, (int)0));
        this.colorRegistry.put("COLOR_DARK_RED", ColorUtils.getRelativeRGB((int)128, (int)0, (int)0));
        this.colorRegistry.put("COLOR_GREEN", ColorUtils.getRelativeRGB((int)0, (int)255, (int)0));
        this.colorRegistry.put("COLOR_DARK_GREEN", ColorUtils.getRelativeRGB((int)0, (int)128, (int)0));
        this.colorRegistry.put("COLOR_YELLOW", ColorUtils.getRelativeRGB((int)255, (int)255, (int)0));
        this.colorRegistry.put("COLOR_DARK_YELLOW", ColorUtils.getRelativeRGB((int)128, (int)128, (int)0));
        this.colorRegistry.put("COLOR_BLUE", ColorUtils.getRelativeRGB((int)0, (int)0, (int)255));
        this.colorRegistry.put("COLOR_DARK_BLUE", ColorUtils.getRelativeRGB((int)0, (int)0, (int)128));
        this.colorRegistry.put("COLOR_MAGENTA", ColorUtils.getRelativeRGB((int)255, (int)0, (int)255));
        this.colorRegistry.put("COLOR_DARK_MAGENTA", ColorUtils.getRelativeRGB((int)128, (int)0, (int)128));
        this.colorRegistry.put("COLOR_CYAN", ColorUtils.getRelativeRGB((int)0, (int)255, (int)255));
        this.colorRegistry.put("COLOR_DARK_CYAN", ColorUtils.getRelativeRGB((int)0, (int)128, (int)128));
        this.colorRegistry.put("COLOR_GRAY", ColorUtils.getRelativeRGB((int)192, (int)192, (int)192));
        this.colorRegistry.put("COLOR_DARK_GRAY", ColorUtils.getRelativeRGB((int)128, (int)128, (int)128));
        this.colorRegistry.put("handlerLinkOne", ColorUtils.getRelativeRGB((int)222, (int)145, (int)29));
        this.colorRegistry.put("handlerLinkTwo", ColorUtils.getRelativeRGB((int)124, (int)151, (int)203));
        this.colorRegistry.put("handlerLinkThree", ColorUtils.getRelativeRGB((int)179, (int)179, (int)179));
        this.colorRegistry.put("handlerLinkFour", ColorUtils.getRelativeRGB((int)255, (int)0, (int)0));
    }

    public ColorRegistry getColorRegistry() {
        if (this.colorRegistry == null) {
            this.initialize();
        }
        return this.colorRegistry;
    }

    public ImageRegistry getImageRegistry() {
        ImageRegistry result = super.getImageRegistry();
        this.initialize();
        return result;
    }

    private void initializeImages() {
        Field[] fields;
        URL baseURL = this.getBundle().getEntry("/");
        Field[] fieldArray = fields = IBPELUIConstants.class.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            Field f = fieldArray[n2];
            if (f.getType() == String.class && ((name = f.getName()).startsWith("ICON_") || name.startsWith("CURSOR_"))) {
                try {
                    String value = (String)f.get(null);
                    this.createImageDescriptor(value, baseURL);
                }
                catch (Exception e) {
                    BPELUIPlugin.log(e);
                }
            }
            ++n2;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
        this.initializePreferences();
        this.initializeResourceChangeListener();
        this.initFunctions();
    }

    protected void initializePreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault("pref_show_freeform_flow", true);
        store.setDefault("pref_warn_links", true);
        store.setDefault("pref_auto_flow_layout", false);
        store.setDefault("pref_use_animation", true);
        store.setDefault("pref_create_spec_compliant", false);
    }

    private void initializeResourceChangeListener() throws CoreException {
        this.resourceChangeListener = new BPELResourceChangeListener();
        Thread initSaveParticipantThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    workspace.addResourceChangeListener((IResourceChangeListener)BPELUIPlugin.this.resourceChangeListener, 16);
                    ISavedState savedState = workspace.addSaveParticipant((Plugin)BPELUIPlugin.this, BPELUIPlugin.this.getSaveParticipant());
                    if (savedState != null) {
                        savedState.processResourceChangeEvents((IResourceChangeListener)BPELUIPlugin.this.resourceChangeListener);
                    }
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        initSaveParticipantThread.setName("BPELUIPlugin init");
        initSaveParticipantThread.start();
    }

    public boolean activateZoomSupport() {
        return false;
    }

    public Templates getTemplates() {
        if (this.mTemplates == null) {
            this.mTemplates = new Templates();
            this.mTemplates.initializeFrom(this.getBundle());
        }
        return this.mTemplates;
    }

    protected void initialize() {
        if (!this.imagesAndColorsInitialized) {
            this.imagesAndColorsInitialized = true;
            this.initializeImages();
            this.initializeColors();
        }
    }

    void initFunctions() {
        Job job = new Job("Reading XPath Function Registry ..."){

            protected IStatus run(IProgressMonitor monitor) {
                Status status;
                long start = System.currentTimeMillis();
                try {
                    Functions.getInstance("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0");
                    status = new Status(0, BPELUIPlugin.PLUGIN_ID, 0, "Done", null);
                }
                catch (Throwable t) {
                    BPELUIPlugin.log(t);
                    status = new Status(4, BPELUIPlugin.PLUGIN_ID, 0, t.getLocalizedMessage(), t);
                }
                long end = System.currentTimeMillis();
                System.out.println("InitFunctions took: " + (end - start) + "ms");
                monitor.done();
                this.done(Job.ASYNC_FINISH);
                return status;
            }
        };
        job.setPriority(20);
        job.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            workspace.removeResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
        }
    }

    private ISaveParticipant getSaveParticipant() {
        if (this.saveParticipant == null) {
            this.saveParticipant = new ISaveParticipant(){

                public void doneSaving(ISaveContext context) {
                }

                public void prepareToSave(ISaveContext context) throws CoreException {
                }

                public void rollback(ISaveContext context) {
                }

                public void saving(ISaveContext context) throws CoreException {
                    context.needDelta();
                }
            };
        }
        return this.saveParticipant;
    }

    public BPELResourceChangeListener getResourceChangeListener() {
        return this.resourceChangeListener;
    }

    public IDialogSettings getDialogSettingsFor(Object object) {
        IDialogSettings main;
        IDialogSettings settings;
        String name = object.getClass().getName();
        if (object instanceof String) {
            name = (String)object;
        }
        if ((settings = (main = this.getDialogSettings()).getSection(name)) == null) {
            settings = main.addNewSection(name);
        }
        return settings;
    }

    public static void log(Throwable e, int severity) {
        String m;
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(severity, PLUGIN_ID, 0, (m = e.getMessage()) == null ? "<no message>" : m, e);
        System.out.println(String.valueOf(e.getClass().getName()) + ": " + status);
        INSTANCE.getLog().log(status);
    }

    public static void log(Throwable e, String message, int severity) {
        Status status = new Status(severity, PLUGIN_ID, message, e);
        INSTANCE.getLog().log((IStatus)status);
    }

    public static void log(Throwable throwable) {
        BPELUIPlugin.log(throwable, 4);
    }
}

