/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui;

import java.util.EventObject;
import org.eclipse.bpel.common.extension.model.ExtensionMap;
import org.eclipse.bpel.common.ui.editmodel.EditModelCommandStack;
import org.eclipse.bpel.ui.extensions.BPELUIRegistry;
import org.eclipse.bpel.ui.extensions.ListenerDescriptor;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.gef.commands.CommandStackListener;

public class ModelListenerAdapter
extends EContentAdapter
implements CommandStackListener {
    ExtensionMap fxtensionMap = null;
    Adapter linkNotificationAdapter;
    int executionStackLevel = 0;
    boolean ignoreChanges = true;

    public void setLinkNotificationAdapter(Adapter adapter) {
        this.linkNotificationAdapter = adapter;
    }

    public void notifyChanged(Notification n) {
        super.notifyChanged(n);
        ListenerDescriptor[] listenerDescriptorArray = BPELUIRegistry.getInstance().getListenerDescriptors();
        int n2 = listenerDescriptorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ListenerDescriptor desc = listenerDescriptorArray[n3];
            desc.getModelListener().handleChange(n);
            ++n3;
        }
        if (!this.ignoreChanges && this.linkNotificationAdapter != null) {
            this.linkNotificationAdapter.notifyChanged(n);
        }
    }

    public void setTarget(Notifier notifier) {
        super.setTarget(notifier);
        if (notifier instanceof EObject && this.fxtensionMap != null && this.executionStackLevel > 0) {
            ModelHelper.createExtensionIfNecessary(this.fxtensionMap, (EObject)notifier);
        }
    }

    public void setExtensionMap(ExtensionMap extensionMap) {
        this.fxtensionMap = extensionMap;
    }

    public void commandStackChanged(EventObject e) {
        if (e instanceof EditModelCommandStack.SharedCommandStackChangedEvent) {
            switch (((EditModelCommandStack.SharedCommandStackChangedEvent)e).getProperty()) {
                case 1: {
                    ++this.executionStackLevel;
                    this.ignoreChanges = false;
                    break;
                }
                case 3: 
                case 5: {
                    this.ignoreChanges = false;
                    break;
                }
                case 2: {
                    --this.executionStackLevel;
                    this.ignoreChanges = true;
                    break;
                }
                case 4: 
                case 6: {
                    this.ignoreChanges = true;
                }
            }
        }
    }
}

