/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands;

import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.OpaqueActivity;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.model.util.ReconciliationHelper;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.adapters.IContainer;
import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.bpel.ui.commands.util.AutoUndoCommand;
import org.eclipse.bpel.ui.uiextensionmodel.impl.EndNodeImpl;
import org.eclipse.bpel.ui.util.BPELEditorUtil;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Node;

public class InsertInContainerCommand
extends AutoUndoCommand {
    protected EObject child;
    protected EObject parent;
    protected EObject before;
    protected Rectangle rect;

    public InsertInContainerCommand(EObject aParent, EObject aChild, EObject aBeforeMarker) {
        super(Messages.InsertInContainerCommand_Add_Node_1, aParent);
        this.parent = aParent;
        this.child = aChild;
        this.before = aBeforeMarker;
        ILabeledElement labeledElement = BPELUtil.adapt((Object)this.child, ILabeledElement.class);
        String childType = null;
        if (labeledElement != null) {
            childType = labeledElement.getTypeLabel(this.child);
        }
        if (childType == null) {
            childType = Messages.InsertInContainerCommand_Node_3;
        }
        this.setLabel(NLS.bind((String)Messages.InsertInContainerCommand_Add_1, (Object[])new Object[]{childType}));
    }

    @Override
    public boolean canDoExecute() {
        Process process;
        IContainer container = BPELUtil.adapt((Object)this.parent, IContainer.class);
        if (this.child instanceof OpaqueActivity && !BPELUtils.isAbstractProcess((Process)(process = BPELUtils.getProcess((Object)this.parent))) && !MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.Make_Process_Abstract_Title, (String)Messages.Make_Process_Abstract_Message)) {
            return false;
        }
        return container.canAddObject(this.parent, this.child, this.before);
    }

    @Override
    public void doExecute() {
        IContainer container = BPELUtil.adapt((Object)this.parent, IContainer.class);
        container.addChild(this.parent, this.child, this.before);
        Node parentElement = InsertInContainerCommand.getRealParentElement(this.child, this.parent);
        Node beforeElement = InsertInContainerCommand.getRealBeforeElement(this.child, this.parent, this.before);
        ReconciliationHelper.getInstance().patchDom(this.child, this.parent, parentElement, this.before, beforeElement);
    }

    private static Node getRealBeforeElement(EObject child, EObject parent, EObject before) {
        if (before != null && !(before instanceof EndNodeImpl)) {
            if (ReconciliationHelper.isSingleActivityContainer((Object)parent) && child instanceof Activity) {
                return ReconciliationHelper.getActivity((Object)parent).getElement().getFirstChild();
            }
            return BPELEditorUtil.getInstance().getElementForObject(before);
        }
        return null;
    }

    private static Node getRealParentElement(EObject child, EObject parent) {
        if (ReconciliationHelper.isSingleActivityContainer((Object)parent) && child instanceof Activity && child != ReconciliationHelper.getActivity((Object)parent)) {
            return BPELEditorUtil.getInstance().getElementForObject(ReconciliationHelper.getActivity((Object)parent));
        }
        if (BPELUtils.isTransparent((Object)parent.eContainer(), (Object)parent)) {
            EObject container = parent.eContainer();
            return BPELEditorUtil.getInstance().getElementForObject(container);
        }
        return BPELEditorUtil.getInstance().getElementForObject(parent);
    }

    public EObject getChild() {
        return this.child;
    }
}

