/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.From;
import org.eclipse.bpel.model.resource.BPELResource;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.IBPELUIConstants;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.adapters.IVirtualCopyRuleSide;
import org.eclipse.bpel.ui.properties.AssignCategoryBase;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LiteralAssignCategory
extends AssignCategoryBase {
    Text fLiteralText;

    protected LiteralAssignCategory(BPELPropertySection ownerSection) {
        super(ownerSection);
    }

    @Override
    public String getName() {
        return Messages.LiteralAssignCategory_Fixed_Value_1;
    }

    @Override
    protected String getLabelFlatFormatString() {
        return IBPELUIConstants.FORMAT_CMD_EDIT;
    }

    @Override
    protected void createClient2(Composite parent) {
        this.fLiteralText = this.fWidgetFactory.createText(parent, "", 514);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment(0, 0);
        data.bottom = new FlatFormAttachment(100, 0);
        this.fLiteralText.setLayoutData((Object)data);
        this.fChangeHelper.startListeningTo(new Control[]{this.fLiteralText});
    }

    @Override
    public boolean isCategoryForModel(EObject aModel) {
        From from = BPELUtil.adapt((Object)aModel, From.class);
        return from != null && from.getLiteral() != null;
    }

    @Override
    protected void load(IVirtualCopyRuleSide aModel) {
        From from = BPELUtil.adapt((Object)aModel.getCopyRuleSide(), From.class);
        this.fChangeHelper.startNonUserChange();
        try {
            String fromString = "";
            if (from != null) {
                fromString = from.getLiteral();
            }
            if (fromString == null) {
                fromString = "";
            }
            this.fLiteralText.setText(fromString);
        }
        finally {
            this.fChangeHelper.finishNonUserChange();
        }
    }

    @Override
    protected void store(IVirtualCopyRuleSide aModel) {
        From from = BPELUtil.adapt((Object)aModel.getCopyRuleSide(), From.class);
        String expr = this.fLiteralText.getText();
        from.setLiteral(expr);
        if (expr == null) {
            from.setUnsafeLiteral(Boolean.FALSE);
        } else if (BPELUtils.convertStringToNode((EObject)from, (String)expr, (BPELResource)((BPELResource)this.getBPELEditor().getResource())) != null) {
            from.setUnsafeLiteral(Boolean.TRUE);
        } else {
            from.setUnsafeLiteral(Boolean.FALSE);
            MessageDialog.openWarning((Shell)this.fLiteralText.getShell(), (String)Messages.LiteralAssignCategory_Warning_1, (String)Messages.LiteralAssignCategory_Literal_not_XML_2);
        }
    }

    @Override
    public Object getUserContext() {
        return null;
    }

    @Override
    public void restoreUserContext(Object userContext) {
        this.fLiteralText.setFocus();
    }
}

