/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.xpath10;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.xpath10.Axis;
import org.eclipse.bpel.xpath10.Predicate;

public class Step {
    int fAxis = 0;
    List<Predicate> fList = new ArrayList<Predicate>();
    int fStartPosition = -1;
    int fEndPosition = -1;

    public Step(int axis) {
        this.fAxis = axis;
    }

    public String getText() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getAxisName());
        buf.append("::");
        buf.append(this.asText());
        for (Predicate p : this.fList) {
            buf.append(p.getText());
        }
        return buf.toString();
    }

    protected String asText() {
        return "?";
    }

    public int getAxis() {
        return this.fAxis;
    }

    public void setAxis(int axis) {
        this.fAxis = axis;
    }

    public void addPredicate(Predicate predicate) {
        if (predicate != null) {
            this.fList.add(predicate);
        }
    }

    public List<Predicate> getPredicates() {
        return this.fList;
    }

    public String getAxisName() {
        return Axis.getName(this.fAxis);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(this.getClass().getSimpleName()).append(",").append(this.getAxisName()).append(",");
        sb.append(this.asString());
        sb.append(",[");
        for (Predicate p : this.fList) {
            sb.append(p);
            sb.append(",");
        }
        sb.append("]");
        sb.append("}");
        return sb.toString();
    }

    protected String asString() {
        return null;
    }

    public int getEndPosition() {
        return this.fEndPosition;
    }

    public int getPosition() {
        return this.fStartPosition;
    }

    public void setPosition(int start, int end) {
        this.fStartPosition = start;
        this.fEndPosition = end;
    }
}

