/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.clad;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractBpmn2PropertySection;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.PropertiesCompositeFactory;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;

public class DefaultPropertySection
extends AbstractBpmn2PropertySection {
    protected AbstractPropertiesProvider propertiesProvider = null;
    protected List<Class> appliesToClasses = new ArrayList<Class>();

    @Override
    protected AbstractDetailComposite createSectionRoot() {
        AbstractDetailComposite composite = null;
        String replaceTab = this.sectionDescriptor.getTabDescriptor().getReplaceTab();
        String afterTab = this.sectionDescriptor.getTabDescriptor().getAfterTab();
        if (this.appliesToClasses.size() == 1 && replaceTab == null && !"top".equals(afterTab)) {
            TargetRuntime targetRuntime = TargetRuntime.getRuntime((IDiagramContainer)this.getDiagramEditor());
            composite = PropertiesCompositeFactory.INSTANCE.createDetailComposite(this.appliesToClasses.get(0), this, targetRuntime);
        } else {
            composite = new DefaultDetailComposite(this);
        }
        composite.setPropertiesProvider(this.propertiesProvider);
        return composite;
    }

    @Override
    public AbstractDetailComposite createSectionRoot(Composite parent, int style) {
        AbstractDetailComposite composite = null;
        String replaceTab = this.sectionDescriptor.getTabDescriptor().getReplaceTab();
        String afterTab = this.sectionDescriptor.getTabDescriptor().getAfterTab();
        if (this.appliesToClasses.size() == 1 && replaceTab == null && !"top".equals(afterTab)) {
            TargetRuntime targetRuntime = TargetRuntime.getRuntime((IDiagramContainer)this.getDiagramEditor());
            composite = PropertiesCompositeFactory.INSTANCE.createDetailComposite(this.appliesToClasses.get(0), parent, targetRuntime, style);
        } else {
            composite = new DefaultDetailComposite(parent, style);
        }
        composite.setPropertiesProvider(this.propertiesProvider);
        return composite;
    }

    protected void setProperties(DefaultDetailComposite composite, String[] properties) {
        this.setProperties(properties);
        composite.setPropertiesProvider(this.propertiesProvider);
    }

    public void setProperties(String[] properties) {
        this.propertiesProvider = new AbstractPropertiesProvider(null){
            String[] properties;
            {
                this.properties = null;
            }

            @Override
            public String[] getProperties() {
                return this.properties;
            }

            @Override
            public void setProperties(String[] properties) {
                this.properties = properties;
            }
        };
        this.propertiesProvider.setProperties(properties);
    }

    @Override
    public boolean appliesTo(IWorkbenchPart part, ISelection selection) {
        if (super.appliesTo(part, selection)) {
            if (this.appliesToClasses.isEmpty()) {
                return true;
            }
            PictogramElement pe = BusinessObjectUtil.getPictogramElementForSelection(selection);
            if (pe instanceof ConnectionDecorator) {
                if ((pe = ((ConnectionDecorator)pe).getConnection()).getLink() == null && pe.eContainer() instanceof PictogramElement) {
                    pe = (PictogramElement)pe.eContainer();
                }
                if (pe.getLink() != null) {
                    for (EObject eObj : pe.getLink().getBusinessObjects()) {
                        if (!this.appliesTo(eObj)) continue;
                        return true;
                    }
                }
            }
            return this.appliesTo(this.getBusinessObjectForSelection(selection));
        }
        return false;
    }

    public boolean appliesTo(EObject eObj) {
        if (this.isModelObjectEnabled(eObj)) {
            for (Class c : this.appliesToClasses) {
                if (!c.isInstance(eObj)) continue;
                return true;
            }
        }
        return false;
    }

    public void addAppliesToClass(Class c) {
        this.appliesToClasses.add(c);
    }

    @Override
    public EObject getBusinessObjectForSelection(ISelection selection) {
        EObject bo = BusinessObjectUtil.getBusinessObjectForSelection(selection);
        if (bo instanceof BPMNDiagram && ((BPMNDiagram)bo).getPlane() != null && ((BPMNDiagram)bo).getPlane().getBpmnElement() != null) {
            return ((BPMNDiagram)bo).getPlane().getBpmnElement();
        }
        return bo;
    }
}

