/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.adapters.properties;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CallableElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.Import;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.utils.ImportUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.ActivityPropertiesAdapter;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.Messages;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.RootElementRefFeatureDescriptor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

public class CallActivityPropertiesAdapter
extends ActivityPropertiesAdapter<CallActivity> {
    public CallActivityPropertiesAdapter(AdapterFactory adapterFactory, CallActivity object) {
        super(adapterFactory, object);
        EReference ce = Bpmn2Package.eINSTANCE.getCallActivity_CalledElementRef();
        this.setProperty((EStructuralFeature)ce, "ui.can.create.new", Boolean.TRUE);
        this.setProperty((EStructuralFeature)ce, "ui.is.multi.choice", Boolean.TRUE);
        this.setFeatureDescriptor((EStructuralFeature)ce, new RootElementRefFeatureDescriptor<CallActivity>((ExtendedPropertiesAdapter)this, object, (EStructuralFeature)ce){

            public String getLabel() {
                return Messages.CallActivityPropertiesAdapter_Called_Element;
            }

            public String getTextValue() {
                CallableElement ce = ((CallActivity)this.object).getCalledElementRef();
                if (ce != null && ce.eIsProxy()) {
                    URI uri = ((InternalEObject)ce).eProxyURI();
                    if (uri.hasFragment()) {
                        return uri.fragment();
                    }
                    return uri.lastSegment();
                }
                return super.getTextValue();
            }

            @Override
            public Hashtable<String, Object> getChoiceOfValues() {
                String label;
                Hashtable<String, Object> choices = new Hashtable<String, Object>();
                Definitions defs = ModelUtil.getDefinitions((Object)this.object);
                List localProcesses = ModelUtil.getAllRootElements((Definitions)defs, CallableElement.class);
                for (CallableElement elem : localProcesses) {
                    label = String.valueOf(ExtendedPropertiesProvider.getTextValue((EObject)elem)) + " (" + elem.getId() + ")";
                    choices.put(label, elem);
                }
                ImportUtil importer = new ImportUtil();
                List imports = defs.getImports();
                for (Import imp : imports) {
                    if (!"http://www.omg.org/spec/BPMN/20100524/MODEL".equals(imp.getImportType())) continue;
                    Definitions importDefs = null;
                    Object importedObject = importer.loadImport(imp);
                    if (importedObject instanceof DocumentRoot) {
                        importDefs = ((DocumentRoot)importedObject).getDefinitions();
                    } else if (importedObject instanceof Definitions) {
                        importDefs = (Definitions)importedObject;
                    }
                    if (importDefs == null) continue;
                    for (RootElement elem : importDefs.getRootElements()) {
                        if (!(elem instanceof CallableElement)) continue;
                        label = String.valueOf(ExtendedPropertiesProvider.getTextValue((EObject)elem)) + " (" + imp.getLocation() + ")";
                        choices.put(label, elem);
                    }
                }
                EObject parent = ((CallActivity)this.object).eContainer();
                while (parent != null && !(parent instanceof CallableElement)) {
                    parent = parent.eContainer();
                }
                ArrayList<String> keys = new ArrayList<String>();
                for (Map.Entry entry : choices.entrySet()) {
                    if (entry.getValue() != parent) continue;
                    keys.add((String)entry.getKey());
                }
                for (String key : keys) {
                    choices.remove(key);
                }
                return choices;
            }
        });
    }
}

