/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.wizard.project;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.buildship.core.BuildConfiguration;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.SynchronizationResult;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.DefaultGradleBuild;
import org.eclipse.buildship.core.internal.operation.ToolingApiOperation;
import org.eclipse.buildship.core.internal.operation.ToolingApiStatus;
import org.eclipse.buildship.core.internal.util.binding.Property;
import org.eclipse.buildship.core.internal.util.binding.ValidationListener;
import org.eclipse.buildship.core.internal.util.binding.Validator;
import org.eclipse.buildship.core.internal.util.binding.Validators;
import org.eclipse.buildship.core.internal.util.collections.CollectionsUtils;
import org.eclipse.buildship.core.internal.util.file.FileUtils;
import org.eclipse.buildship.core.internal.workspace.NewProjectHandler;
import org.eclipse.buildship.ui.internal.util.gradle.GradleDistributionViewModel;
import org.eclipse.buildship.ui.internal.util.workbench.WorkbenchUtils;
import org.eclipse.buildship.ui.internal.util.workbench.WorkingSetUtils;
import org.eclipse.buildship.ui.internal.wizard.project.InitializeNewProjectOperation;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectImportConfiguration;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectWizardMessages;
import org.eclipse.buildship.ui.internal.wizard.project.WizardHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.gradle.tooling.GradleConnector;

public class ProjectImportWizardController {
    private static final String SETTINGS_KEY_PROJECT_DIR = "project_location";
    private static final String SETTINGS_KEY_GRADLE_DISTRIBUTION = "gradle_distribution";
    private static final String SETTINGS_KEY_APPLY_WORKING_SETS = "apply_working_sets";
    private static final String SETTINGS_KEY_WORKING_SETS = "working_sets";
    private static final String SETTINGS_KEY_GRADLE_USER_HOME = "gradle_user_home";
    private static final String SETTINGS_KEY_BUILD_SCANS = "build_scans";
    private static final String SETTINGS_KEY_OFFLINE_MODE = "offline_mode";
    private static final String SETTINGS_KEY_AUTO_SYNC = "auto_sync";
    private final ProjectImportConfiguration configuration;

    public ProjectImportWizardController(IWizard projectImportWizard) {
        GradleDistribution distribution;
        Validator projectDirValidator = Validators.and((Validator)Validators.requiredDirectoryValidator((String)ProjectWizardMessages.Label_ProjectRootDirectory), (Validator)Validators.nonWorkspaceFolderValidator((String)ProjectWizardMessages.Label_ProjectRootDirectory));
        Validator<GradleDistributionViewModel> gradleDistributionValidator = GradleDistributionViewModel.validator();
        Validator applyWorkingSetsValidator = Validators.nullValidator();
        Validator workingSetsValidator = Validators.nullValidator();
        Validator gradleUserHomeValidator = Validators.optionalDirectoryValidator((String)"Gradle user home");
        this.configuration = new ProjectImportConfiguration((Validator<File>)projectDirValidator, gradleDistributionValidator, (Validator<File>)gradleUserHomeValidator, (Validator<Boolean>)applyWorkingSetsValidator, (Validator<List<String>>)workingSetsValidator);
        IDialogSettings dialogSettings = projectImportWizard.getDialogSettings();
        Optional projectDir = FileUtils.getAbsoluteFile((String)dialogSettings.get(SETTINGS_KEY_PROJECT_DIR));
        String gradleDistributionString = dialogSettings.get(SETTINGS_KEY_GRADLE_DISTRIBUTION);
        Optional gradleUserHome = FileUtils.getAbsoluteFile((String)dialogSettings.get(SETTINGS_KEY_GRADLE_USER_HOME));
        boolean applyWorkingSets = dialogSettings.get(SETTINGS_KEY_APPLY_WORKING_SETS) != null && dialogSettings.getBoolean(SETTINGS_KEY_APPLY_WORKING_SETS);
        ImmutableList workingSets = ImmutableList.copyOf((Object[])CollectionsUtils.nullToEmpty((String[])dialogSettings.getArray(SETTINGS_KEY_WORKING_SETS)));
        boolean buildScansEnabled = dialogSettings.getBoolean(SETTINGS_KEY_BUILD_SCANS);
        boolean offlineMode = dialogSettings.getBoolean(SETTINGS_KEY_OFFLINE_MODE);
        boolean autoSync = dialogSettings.getBoolean(SETTINGS_KEY_AUTO_SYNC);
        this.configuration.setProjectDir((File)projectDir.orNull());
        this.configuration.setOverwriteWorkspaceSettings(false);
        try {
            distribution = GradleDistribution.fromString((String)gradleDistributionString);
        }
        catch (RuntimeException ignore) {
            distribution = GradleDistribution.fromBuild();
        }
        this.configuration.setDistribution(GradleDistributionViewModel.from(distribution));
        this.configuration.setGradleUserHome((File)gradleUserHome.orNull());
        this.configuration.setApplyWorkingSets(applyWorkingSets);
        this.configuration.setWorkingSets((List<String>)workingSets);
        this.configuration.setBuildScansEnabled(buildScansEnabled);
        this.configuration.setOfflineMode(offlineMode);
        this.configuration.setAutoSync(autoSync);
        this.saveFilePropertyWhenChanged(dialogSettings, SETTINGS_KEY_PROJECT_DIR, this.configuration.getProjectDir());
        this.saveDistributionPropertyWhenChanged(dialogSettings, this.configuration.getDistribution());
        this.saveFilePropertyWhenChanged(dialogSettings, SETTINGS_KEY_GRADLE_USER_HOME, this.configuration.getGradleUserHome());
        this.saveBooleanPropertyWhenChanged(dialogSettings, SETTINGS_KEY_APPLY_WORKING_SETS, this.configuration.getApplyWorkingSets());
        this.saveStringArrayPropertyWhenChanged(dialogSettings, SETTINGS_KEY_WORKING_SETS, this.configuration.getWorkingSets());
        this.saveBooleanPropertyWhenChanged(dialogSettings, SETTINGS_KEY_BUILD_SCANS, this.configuration.getBuildScansEnabled());
        this.saveBooleanPropertyWhenChanged(dialogSettings, SETTINGS_KEY_OFFLINE_MODE, this.configuration.getOfflineMode());
        this.saveBooleanPropertyWhenChanged(dialogSettings, SETTINGS_KEY_AUTO_SYNC, this.configuration.getAutoSync());
    }

    private void saveBooleanPropertyWhenChanged(final IDialogSettings settings, final String settingsKey, final Property<Boolean> target) {
        target.addValidationListener(new ValidationListener(){

            public void validationTriggered(Property<?> source, Optional<String> validationErrorMessage) {
                settings.put(settingsKey, ((Boolean)target.getValue()).booleanValue());
            }
        });
    }

    private void saveStringArrayPropertyWhenChanged(final IDialogSettings settings, final String settingsKey, final Property<List<String>> target) {
        target.addValidationListener(new ValidationListener(){

            public void validationTriggered(Property<?> source, Optional<String> validationErrorMessage) {
                List value = (List)target.getValue();
                settings.put(settingsKey, value.toArray(new String[value.size()]));
            }
        });
    }

    private void saveFilePropertyWhenChanged(final IDialogSettings settings, final String settingsKey, final Property<File> target) {
        target.addValidationListener(new ValidationListener(){

            public void validationTriggered(Property<?> source, Optional<String> validationErrorMessage) {
                settings.put(settingsKey, (String)FileUtils.getAbsolutePath((File)((File)target.getValue())).orNull());
            }
        });
    }

    private void saveDistributionPropertyWhenChanged(final IDialogSettings settings, final Property<GradleDistributionViewModel> target) {
        target.addValidationListener(new ValidationListener(){

            public void validationTriggered(Property<?> source, Optional<String> validationErrorMessage) {
                if (!validationErrorMessage.isPresent()) {
                    settings.put(ProjectImportWizardController.SETTINGS_KEY_GRADLE_DISTRIBUTION, ((GradleDistributionViewModel)target.getValue()).toGradleDistribution().toString());
                } else {
                    settings.put(ProjectImportWizardController.SETTINGS_KEY_GRADLE_DISTRIBUTION, GradleDistribution.fromBuild().toString());
                }
            }
        });
    }

    public ProjectImportConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean performImportProject(IWizardContainer container, final NewProjectHandler newProjectHandler) {
        try {
            container.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    org.eclipse.buildship.core.internal.configuration.BuildConfiguration internalBuildConfiguration = ProjectImportWizardController.this.configuration.toInternalBuildConfiguration();
                    BuildConfiguration buildConfiguration = ProjectImportWizardController.this.configuration.toBuildConfiguration();
                    GradleBuild gradleBuild = GradleCore.getWorkspace().createBuild(buildConfiguration);
                    ImportWizardNewProjectHandler workingSetsAddingNewProjectHandler = new ImportWizardNewProjectHandler(newProjectHandler, ProjectImportWizardController.this.configuration);
                    InitializeNewProjectOperation initializeOperation = new InitializeNewProjectOperation(internalBuildConfiguration);
                    try {
                        CorePlugin.operationManager().run((ToolingApiOperation)initializeOperation, monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                    SynchronizationResult result = ((DefaultGradleBuild)gradleBuild).synchronize((NewProjectHandler)workingSetsAddingNewProjectHandler, GradleConnector.newCancellationTokenSource(), monitor);
                    if (!result.getStatus().isOK()) {
                        throw new InvocationTargetException(new CoreException(result.getStatus()));
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            ToolingApiStatus status = WizardHelper.containerExceptionToToolingApiStatus(e);
            status.log();
            return !ToolingApiStatus.ToolingApiStatusType.IMPORT_ROOT_DIR_FAILED.matches(status);
        }
        catch (InterruptedException ignored) {
            return false;
        }
        return true;
    }

    private static final class ImportWizardNewProjectHandler
    implements NewProjectHandler {
        private final ProjectImportConfiguration configuration;
        private final NewProjectHandler importedBuildDelegate;
        private volatile boolean gradleViewsVisible;

        private ImportWizardNewProjectHandler(NewProjectHandler delegate, ProjectImportConfiguration configuration) {
            this.importedBuildDelegate = delegate;
            this.configuration = configuration;
        }

        public boolean shouldImportNewProjects() {
            return this.importedBuildDelegate.shouldImportNewProjects();
        }

        public void afterProjectImported(IProject project) {
            this.importedBuildDelegate.afterProjectImported(project);
            this.addWorkingSets(project);
            this.ensureGradleViewsAreVisible();
        }

        private void addWorkingSets(IProject project) {
            ImmutableList workingSetNames = (Boolean)this.configuration.getApplyWorkingSets().getValue() != false ? ImmutableList.copyOf((Collection)((Collection)this.configuration.getWorkingSets().getValue())) : ImmutableList.of();
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            IWorkingSet[] workingSets = WorkingSetUtils.toWorkingSets((List<String>)workingSetNames);
            workingSetManager.addToWorkingSets((IAdaptable)project, workingSets);
        }

        private void ensureGradleViewsAreVisible() {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!gradleViewsVisible) {
                        gradleViewsVisible = true;
                        WorkbenchUtils.showView("org.eclipse.buildship.ui.views.taskview", null, 1);
                        WorkbenchUtils.showView("org.eclipse.buildship.ui.views.executionview", null, 2);
                    }
                }
            });
        }
    }
}

