/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.automake;

import java.util.ArrayList;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.Util;

public class PosixMakefileUtil {
    public static String[] findPrerequisites(String line) {
        return PosixMakefileUtil.findTargets(line);
    }

    public static String[] findTargets(String line) {
        int space;
        ArrayList<String> aList = new ArrayList<String>();
        line = line.trim();
        while ((space = Util.indexOf(line, " \t")) != -1) {
            aList.add(line.substring(0, space).trim());
            line = line.substring(space + 1).trim();
        }
        if (line.length() > 0) {
            aList.add(line);
        }
        return aList.toArray(new String[0]);
    }

    public static boolean isMacroDefinition(String line) {
        return Util.indexOf(line, '=') != -1;
    }

    public static boolean isTargetRule(String line) {
        return Util.indexOf(line, ':') != -1;
    }

    public static boolean isCommand(String line) {
        return line.length() > 1 && line.charAt(0) == '\t';
    }

    public static boolean isEmptyLine(String line) {
        return line.trim().length() == 0;
    }

    public static boolean isInferenceRule(String line) {
        int index;
        return (line = line.trim()).startsWith(".") && (index = Util.indexOf(line, ':')) > 1 && ((line = line.substring(index + 1).trim()).length() == 0 || line.equals(";"));
    }

    public static boolean isDefaultRule(String line) {
        int colon = Util.indexOf(line = line.trim(), ':');
        if (colon > 0) {
            line = line.substring(0, colon).trim();
            return line.equals(".DEFAULT");
        }
        return false;
    }

    public static boolean isIgnoreRule(String line) {
        int colon = Util.indexOf(line = line.trim(), ':');
        if (colon > 0) {
            line = line.substring(0, colon).trim();
            return line.equals(".IGNORE");
        }
        return false;
    }

    public static boolean isPosixRule(String line) {
        int colon = Util.indexOf(line = line.trim(), ':');
        if (colon > 0) {
            line = line.substring(0, colon).trim();
            return line.equals(".POSIX");
        }
        return false;
    }

    public static boolean isPreciousRule(String line) {
        int colon = Util.indexOf(line = line.trim(), ':');
        if (colon > 0) {
            line = line.substring(0, colon).trim();
            return line.equals(".PRECIOUS");
        }
        return false;
    }

    public static boolean isSccsGetRule(String line) {
        int colon = Util.indexOf(line = line.trim(), ':');
        if (colon > 0) {
            line = line.substring(0, colon).trim();
            return line.equals(".SCCS_GET");
        }
        return false;
    }

    public static boolean isSilentRule(String line) {
        int colon = Util.indexOf(line = line.trim(), ':');
        if (colon > 0) {
            line = line.substring(0, colon).trim();
            return line.equals(".SILENT");
        }
        return false;
    }

    public static boolean isSuffixesRule(String line) {
        int colon = Util.indexOf(line = line.trim(), ':');
        if (colon > 0) {
            line = line.substring(0, colon).trim();
            return line.equals(".SUFFIXES");
        }
        return false;
    }

    public static boolean isLibraryTarget(String line) {
        int prev = 0;
        int paren = 0;
        int i = 0;
        while (i < line.length()) {
            char ch = line.charAt(i);
            if (ch == '(' && prev != 36 && prev != 92) {
                ++paren;
            } else if (ch == ')' && prev != 92 && paren > 0) {
                return true;
            }
            prev = ch;
            ++i;
        }
        return false;
    }
}

