/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.lrparser.action;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;

public class ASTCompletionNode
implements IASTCompletionNode {
    private final List<IASTCompletionNode.CompletionNameEntry> entries = new ArrayList<IASTCompletionNode.CompletionNameEntry>();
    private final String prefix;
    private IASTTranslationUnit tu;

    public ASTCompletionNode(String prefix, IASTTranslationUnit tu) {
        if ("".equals(prefix)) {
            prefix = null;
        }
        this.prefix = prefix;
        this.tu = tu;
    }

    public ASTCompletionNode(String prefix) {
        this(prefix, null);
    }

    public void addName(IASTName name) {
        this.entries.add(new IASTCompletionNode.CompletionNameEntry(name, name.getParent()));
    }

    public int getLength() {
        return this.prefix == null ? 0 : this.prefix.length();
    }

    public IASTName[] getNames() {
        IASTName[] names = new IASTName[this.entries.size()];
        int i = 0;
        while (i < this.entries.size()) {
            names[i] = this.entries.get((int)i).fName;
            ++i;
        }
        return names;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setTranslationUnit(IASTTranslationUnit tu) {
        this.tu = tu;
    }

    public IASTTranslationUnit getTranslationUnit() {
        return this.tu;
    }

    public boolean containsName(IASTName name) {
        for (IASTCompletionNode.CompletionNameEntry entry : this.entries) {
            if (entry.fName != name) continue;
            return true;
        }
        return false;
    }

    public IASTCompletionNode.CompletionNameEntry[] getEntries() {
        return this.entries.toArray(new IASTCompletionNode.CompletionNameEntry[this.entries.size()]);
    }
}

