/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAttributeOwner;

public class CPPASTArrayModifier
extends CPPASTAttributeOwner
implements IASTArrayModifier {
    private IASTExpression exp;

    public CPPASTArrayModifier() {
    }

    public CPPASTArrayModifier(IASTExpression exp) {
        this.setConstantExpression(exp);
    }

    @Override
    public IASTExpression getConstantExpression() {
        return this.exp;
    }

    @Override
    public CPPASTArrayModifier copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTArrayModifier copy(IASTNode.CopyStyle style) {
        CPPASTArrayModifier copy = new CPPASTArrayModifier(this.exp == null ? null : this.exp.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public void setConstantExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.exp = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(CONSTANT_EXPRESSION);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitArrayModifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.exp != null && !this.exp.accept(action)) {
            return false;
        }
        if (!this.acceptByAttributeSpecifiers(action)) {
            return false;
        }
        return !action.shouldVisitArrayModifiers || action.leave(this) != 2;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.exp) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.exp = (IASTExpression)other;
            return;
        }
        super.replace(child, other);
    }
}

