/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFunctionCall;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.InitializerListType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public final class EvalCompositeAccess
implements ICPPEvaluation {
    private final ICPPEvaluation parent;
    private final int elementId;

    public EvalCompositeAccess(ICPPEvaluation parent, int elementId) {
        Assert.isNotNull((Object)parent);
        this.parent = parent;
        this.elementId = elementId;
    }

    public void update(ICPPEvaluation newValue) {
        this.parent.getValue().setSubValue(this.elementId, newValue);
    }

    @Override
    public boolean isInitializerList() {
        return this.getTargetEvaluation().isInitializerList();
    }

    private ICPPEvaluation getTargetEvaluation() {
        return this.parent.getValue().getSubValue(this.elementId);
    }

    @Override
    public boolean isFunctionSet() {
        return this.getTargetEvaluation().isFunctionSet();
    }

    @Override
    public boolean isTypeDependent() {
        return this.getTargetEvaluation().isTypeDependent();
    }

    @Override
    public boolean isValueDependent() {
        return this.getTargetEvaluation().isValueDependent();
    }

    @Override
    public boolean isConstantExpression() {
        return this.getTargetEvaluation().isConstantExpression();
    }

    @Override
    public boolean isEquivalentTo(ICPPEvaluation other) {
        if (!(other instanceof EvalCompositeAccess)) {
            return false;
        }
        EvalCompositeAccess o = (EvalCompositeAccess)other;
        return this.parent.isEquivalentTo(o.parent) && this.elementId == o.elementId;
    }

    @Override
    public IType getType() {
        IType type = this.getParent().getType();
        if ((type = SemanticUtil.getNestedType(type, 13)) instanceof IArrayType) {
            IArrayType arrayType = (IArrayType)type;
            return arrayType.getType();
        }
        if (type instanceof InitializerListType) {
            InitializerListType initListType = (InitializerListType)type;
            ICPPEvaluation[] clauses = initListType.getEvaluation().getClauses();
            if (this.elementId >= 0 && this.elementId < clauses.length) {
                return clauses[this.elementId].getType();
            }
            return new ProblemType(10004);
        }
        if (type instanceof ICPPClassType) {
            ICPPClassType classType = (ICPPClassType)type;
            ICPPField[] fields = ClassTypeHelper.getFields(classType);
            if (this.elementId >= 0 && this.elementId < fields.length) {
                return fields[this.elementId].getType();
            }
            return new ProblemType(10004);
        }
        if (type instanceof EvalFunctionCall.ParameterPackType) {
            EvalFunctionCall.ParameterPackType parameterPackType = (EvalFunctionCall.ParameterPackType)type;
            return parameterPackType.getTypes()[this.elementId];
        }
        if (type instanceof ICPPBasicType) {
            return type;
        }
        return null;
    }

    @Override
    public IValue getValue() {
        return this.getTargetEvaluation().getValue();
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.getTargetEvaluation().getValueCategory();
    }

    @Override
    public char[] getSignature() {
        return this.getTargetEvaluation().getSignature();
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        if (this.getTargetEvaluation() != EvalFixed.INCOMPLETE) {
            return this.getTargetEvaluation().computeForFunctionCall(record, context);
        }
        ICPPEvaluation evaluatedComposite = this.parent.computeForFunctionCall(record, context);
        return evaluatedComposite.getValue().getSubValue(this.elementId).computeForFunctionCall(record, context);
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        return this.getTargetEvaluation().determinePackSize(tpMap);
    }

    @Override
    public boolean referencesTemplateParameter() {
        return this.getTargetEvaluation().referencesTemplateParameter();
    }

    @Override
    public IBinding getTemplateDefinition() {
        return this.parent.getTemplateDefinition();
    }

    public ICPPEvaluation getParent() {
        return this.parent;
    }

    public int getElementId() {
        return this.elementId;
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        return this.getTargetEvaluation().instantiate(context, maxDepth);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)20);
        buffer.marshalEvaluation(this.parent, includeValue);
        buffer.putInt(this.elementId);
    }

    public static ICPPEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        ICPPEvaluation parent = buffer.unmarshalEvaluation();
        int elementId = buffer.getInt();
        return new EvalCompositeAccess(parent, elementId);
    }
}

