/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.launching;

import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.CLaunchConfigurationTab;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.LaunchImages;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.WorkingDirectoryBlock;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CArgumentsTab
extends CLaunchConfigurationTab {
    public static final String TAB_ID = "org.eclipse.cdt.dsf.gdb.launch.argumentsTab";
    protected Label fPrgmArgumentsLabel;
    protected Text fPrgmArgumentsText;
    protected Button fArgumentVariablesButton;
    protected WorkingDirectoryBlock fWorkingDirectoryBlock = new WorkingDirectoryBlock();

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        comp.setLayout((Layout)layout);
        comp.setFont(font);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.setControl((Control)comp);
        GdbUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.dsf.gdb.ui.launch_configuration_dialog_arguments_tab");
        this.createArgumentComponent(comp, 1);
        this.fWorkingDirectoryBlock.createControl(comp);
    }

    protected void createArgumentComponent(Composite comp, int horizontalSpan) {
        Font font = comp.getFont();
        Group group = new Group(comp, 0);
        group.setFont(font);
        group.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        gd.horizontalSpan = horizontalSpan;
        group.setLayoutData((Object)gd);
        group.setText(LaunchMessages.getString((String)"CArgumentsTab.C/C++_Program_Arguments"));
        this.fPrgmArgumentsText = new Text((Composite)group, 2626);
        this.fPrgmArgumentsText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LaunchMessages.getString((String)"CArgumentsTab.C/C++_Program_Arguments");
            }
        });
        gd = new GridData(1808);
        gd.heightHint = 40;
        gd.widthHint = 100;
        this.fPrgmArgumentsText.setLayoutData((Object)gd);
        this.fPrgmArgumentsText.setFont(font);
        this.fPrgmArgumentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                CArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fArgumentVariablesButton = this.createPushButton((Composite)group, LaunchMessages.getString((String)"CArgumentsTab.Variables"), null);
        gd = new GridData(128);
        this.fArgumentVariablesButton.setLayoutData((Object)gd);
        this.fArgumentVariablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                CArgumentsTab.this.handleVariablesButtonSelected(CArgumentsTab.this.fPrgmArgumentsText);
            }
        });
        this.addControlAccessibleListener((Control)this.fArgumentVariablesButton, this.fArgumentVariablesButton.getText());
    }

    protected void handleVariablesButtonSelected(Text textField) {
        String variable = this.getVariable();
        if (variable != null) {
            textField.insert(variable);
        }
    }

    private String getVariable() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        return dialog.getVariableExpression();
    }

    public void addControlAccessibleListener(Control control, String controlName) {
        String[] strs = controlName.split("&");
        StringBuilder stripped = new StringBuilder();
        int i = 0;
        while (i < strs.length) {
            stripped.append(strs[i]);
            ++i;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stripped.toString()));
    }

    public boolean isValid(ILaunchConfiguration config) {
        return this.fWorkingDirectoryBlock.isValid(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", null);
        config.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fPrgmArgumentsText.setText(configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", ""));
            this.fWorkingDirectoryBlock.initializeFrom(configuration);
        }
        catch (CoreException e) {
            this.setErrorMessage(LaunchMessages.getFormattedString((String)"Launch.common.Exception_occurred_reading_configuration_EXCEPTION", (String)e.getStatus().getMessage()));
            GdbUIPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", this.getAttributeValueFrom(this.fPrgmArgumentsText));
        this.fWorkingDirectoryBlock.performApply(configuration);
    }

    protected String getAttributeValueFrom(Text text) {
        String content = text.getText().trim();
        if (!(content = content.replaceAll("\r\n", "\n")).isEmpty()) {
            return content;
        }
        return null;
    }

    public String getId() {
        return TAB_ID;
    }

    public String getName() {
        return LaunchMessages.getString((String)"CArgumentsTab.Arguments");
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.fWorkingDirectoryBlock.setLaunchConfigurationDialog(dialog);
    }

    public String getErrorMessage() {
        String m = super.getErrorMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getErrorMessage();
        }
        return m;
    }

    public String getMessage() {
        String m = super.getMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getMessage();
        }
        return m;
    }

    public Image getImage() {
        return LaunchImages.get(LaunchImages.IMG_VIEW_ARGUMENTS_TAB);
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    private class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String name) {
            this.controlName = name;
        }

        public void getName(AccessibleEvent e) {
            e.result = this.controlName;
        }
    }
}

