/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.memory;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.model.IMemoryBlockAddressInfoRetrieval;
import org.eclipse.cdt.debug.core.model.provisional.IMemorySpaceAwareMemoryBlock;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IMemorySpaces2;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.memory.MemoryBlockAddressInfoItem;
import org.eclipse.cdt.dsf.gdb.memory.IGdbMemoryAddressInfoTypeRetrieval;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IMemoryBlock;

public class GdbMemoryAddressInfoVariablesRetrieval
implements IGdbMemoryAddressInfoTypeRetrieval {
    private static final String VARIABLES_INFO_TYPE = "Variables";
    private static final int LOCALS_COLOR = 11940049;
    private static final int POINTER_COLOR = 0xFF0000;
    private static final String DEREF_CHAR = "*";
    private static final String EMPTY_STRING = "";
    private final DsfSession fSession;

    public GdbMemoryAddressInfoVariablesRetrieval(DsfSession session) {
        this.fSession = session;
    }

    @Override
    public void itemsRequest(IDMContext context, final IMemoryBlock memBlock, final DataRequestMonitor<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[]> rm) {
        if (this.fSession == null || this.fSession.getExecutor() == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", "Initialization problem, invalid session"));
            return;
        }
        final IStack.IFrameDMContext frameDmc = (IStack.IFrameDMContext)DMContexts.getAncestorOfType((IDMContext)context, IStack.IFrameDMContext.class);
        final IStack stackFrameService = this.resolveService(IStack.class);
        final IExpressions expressionService = this.resolveService(IExpressions.class);
        if (frameDmc == null || expressionService == null || stackFrameService == null) {
            rm.done((IStatus)new Status(1, "org.eclipse.cdt.dsf.gdb", "Unable to resolve Variables for the currently selected context"));
            return;
        }
        final DsfExecutor dsfExecutor = this.fSession.getExecutor();
        stackFrameService.getLocals(frameDmc, (DataRequestMonitor)new DataRequestMonitor<IStack.IVariableDMContext[]>((Executor)dsfExecutor, rm){

            protected void handleSuccess() {
                IStack.IVariableDMContext[] localsDMCs = (IStack.IVariableDMContext[])this.getData();
                if (localsDMCs == null || localsDMCs.length == 0) {
                    rm.setData((Object)new IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[0]);
                    rm.done();
                    return;
                }
                final ArrayList localsDMData = new ArrayList();
                final CountingRequestMonitor crm = new CountingRequestMonitor((Executor)dsfExecutor, (RequestMonitor)rm){

                    public void handleSuccess() {
                        ExpressionBin[] expressionBins = new ExpressionBin[localsDMData.size() * 2];
                        int i = 0;
                        for (IStack.IVariableDMData localDMData : localsDMData) {
                            expressionBins[i++] = GdbMemoryAddressInfoVariablesRetrieval.this.createExpression(expressionService, (IDMContext)frameDmc, localDMData.getName(), false);
                            expressionBins[i++] = GdbMemoryAddressInfoVariablesRetrieval.this.createExpression(expressionService, (IDMContext)frameDmc, GdbMemoryAddressInfoVariablesRetrieval.DEREF_CHAR + localDMData.getName(), true);
                        }
                        GdbMemoryAddressInfoVariablesRetrieval.this.resolveItems(expressionService, expressionBins, frameDmc, memBlock, (DataRequestMonitor<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[]>)rm);
                    }
                };
                int countRM = 0;
                IStack.IVariableDMContext[] iVariableDMContextArray = localsDMCs;
                int n = localsDMCs.length;
                int n2 = 0;
                while (n2 < n) {
                    IStack.IVariableDMContext localDMC = iVariableDMContextArray[n2];
                    stackFrameService.getVariableData(localDMC, (DataRequestMonitor)new DataRequestMonitor<IStack.IVariableDMData>((Executor)dsfExecutor, (RequestMonitor)crm){

                        public void handleSuccess() {
                            localsDMData.add((IStack.IVariableDMData)this.getData());
                            crm.done();
                        }
                    });
                    ++countRM;
                    ++n2;
                }
                crm.setDoneCount(countRM);
            }
        });
    }

    @Override
    public String getInfoType() {
        return VARIABLES_INFO_TYPE;
    }

    private void resolveItems(IExpressions expressionService, ExpressionBin[] expressionsBins, final IStack.IFrameDMContext frameDmc, IMemoryBlock memBlock, DataRequestMonitor<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[]> rm) {
        final DsfExecutor executor = expressionService.getExecutor();
        this.resolveAddressData(expressionService, expressionsBins, new RequestMonitor((Executor)executor, (RequestMonitor)rm, (DataRequestMonitor)rm, expressionsBins, memBlock){
            private final /* synthetic */ DataRequestMonitor val$rm;
            private final /* synthetic */ ExpressionBin[] val$expressionsBins;
            private final /* synthetic */ IMemoryBlock val$memBlock;
            {
                this.val$rm = dataRequestMonitor;
                this.val$expressionsBins = expressionBinArray;
                this.val$memBlock = iMemoryBlock;
                super($anonymous0, $anonymous1);
            }

            protected void handleCompleted() {
                IMemorySpaces2 memSpaceService = (IMemorySpaces2)GdbMemoryAddressInfoVariablesRetrieval.this.resolveService(IMemorySpaces2.class);
                if (memSpaceService != null) {
                    memSpaceService.getDefaultMemorySpace((IDMContext)frameDmc, (DataRequestMonitor)new DataRequestMonitor<String>((Executor)executor, (RequestMonitor)this.val$rm){

                        protected void handleCompleted() {
                            String defaultMemSpaceId = (String)this.getData();
                            val$rm.setData((Object)GdbMemoryAddressInfoVariablesRetrieval.this.createAddressInfoItems(val$expressionsBins, val$memBlock, defaultMemSpaceId));
                            val$rm.done();
                        }
                    });
                } else {
                    this.val$rm.setData((Object)GdbMemoryAddressInfoVariablesRetrieval.this.createAddressInfoItems(this.val$expressionsBins, this.val$memBlock, GdbMemoryAddressInfoVariablesRetrieval.EMPTY_STRING));
                    this.val$rm.done();
                }
            }
        });
    }

    private <V> V resolveService(Class<V> type) {
        Object service = null;
        if (this.fSession != null) {
            DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getDefault().getBundle().getBundleContext(), this.fSession.getId());
            service = tracker.getService(type);
            tracker.dispose();
        }
        return (V)service;
    }

    private ExpressionBin createExpression(IExpressions expressionService, IDMContext dmc, String expression, boolean dereferenced) {
        IExpressions.IExpressionDMContext exprDMC = expressionService.createExpression(dmc, expression);
        return new ExpressionBin(exprDMC, dereferenced);
    }

    private void resolveAddressData(IExpressions expressionService, ExpressionBin[] expressionsBins, RequestMonitor rm) {
        DsfExecutor executor = expressionService.getExecutor();
        final CountingRequestMonitor crm = new CountingRequestMonitor((Executor)executor, rm);
        ExpressionBin[] expressionBinArray = expressionsBins;
        int n = expressionsBins.length;
        int n2 = 0;
        while (n2 < n) {
            final ExpressionBin expBin = expressionBinArray[n2];
            expressionService.getExpressionAddressData(expBin.fContext, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMAddress>((Executor)executor, (RequestMonitor)crm){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        expBin.fAddress = (IExpressions.IExpressionDMAddress)this.getData();
                    }
                    crm.done();
                }
            });
            ++n2;
        }
        crm.setDoneCount(expressionsBins.length);
    }

    private IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[] createAddressInfoItems(ExpressionBin[] contentsBins, IMemoryBlock memBlock, String ctxDefaultMemSpaceId) {
        int length = contentsBins.length;
        ArrayList<MemoryBlockAddressVariableItem> infoItems = new ArrayList<MemoryBlockAddressVariableItem>();
        String memBlockMemSpaceId = EMPTY_STRING;
        if (memBlock instanceof IMemorySpaceAwareMemoryBlock) {
            String tMemBlockMemSpace = ((IMemorySpaceAwareMemoryBlock)memBlock).getMemorySpaceID();
            memBlockMemSpaceId = tMemBlockMemSpace == null ? EMPTY_STRING : tMemBlockMemSpace;
        }
        int i = 0;
        while (i < length) {
            IExpressions.IExpressionDMAddress dmAddress;
            BigInteger addressValue;
            ExpressionBin expBin = contentsBins[i];
            if (expBin.isComplete() && !(addressValue = (dmAddress = expBin.fAddress).getAddress().getValue()).equals(BigInteger.ZERO)) {
                String name = expBin.fContext.getExpression();
                BigInteger exprSize = BigInteger.valueOf(dmAddress.getSize());
                int color = expBin.isDereferenced() ? 0xFF0000 : 11940049;
                String exprMemSpaceId = EMPTY_STRING;
                String exprMemSpace = dmAddress.getMemorySpaceID();
                String string = exprMemSpaceId = exprMemSpace != null ? exprMemSpace : EMPTY_STRING;
                if (memBlockMemSpaceId.length() > 0 && exprMemSpaceId.length() == 0) {
                    exprMemSpaceId = ctxDefaultMemSpaceId;
                }
                if (exprMemSpaceId.equals(memBlockMemSpaceId)) {
                    infoItems.add(new MemoryBlockAddressVariableItem(name, addressValue, exprSize, color));
                }
            }
            ++i;
        }
        return infoItems.toArray(new IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[infoItems.size()]);
    }

    private static final class ExpressionBin {
        private final IExpressions.IExpressionDMContext fContext;
        private IExpressions.IExpressionDMAddress fAddress;
        private boolean fDereferenced;

        public ExpressionBin(IExpressions.IExpressionDMContext expDmc, boolean dereferenced) {
            this.fContext = expDmc;
            this.fDereferenced = dereferenced;
        }

        boolean isDereferenced() {
            return this.fDereferenced;
        }

        boolean isComplete() {
            return this.fContext != null && this.fAddress != null;
        }
    }

    private static class MemoryBlockAddressVariableItem
    extends MemoryBlockAddressInfoItem {
        public MemoryBlockAddressVariableItem(String name, String value) {
            super(name, value);
        }

        public MemoryBlockAddressVariableItem(String name, BigInteger addressValue, BigInteger dataTypeSize, int color) {
            super(name, addressValue, dataTypeSize, color);
        }

        public String getInfoType() {
            return GdbMemoryAddressInfoVariablesRetrieval.VARIABLES_INFO_TYPE;
        }
    }
}

