/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.util;

import org.eclipse.cdt.internal.core.PositionTracker;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;

public class SimplePositionTracker
extends PositionTracker
implements IPositionUpdater {
    private IDocument fDocument;

    public void update(DocumentEvent event) {
        String text = event.getText();
        int insertLen = text != null ? text.length() : 0;
        this.update(event.getOffset(), event.getLength(), insertLen);
    }

    private void update(int offset, int deleteLen, int insertLen) {
        if (insertLen > deleteLen) {
            this.insert(offset + deleteLen, insertLen - deleteLen);
        } else if (insertLen < deleteLen) {
            this.delete(offset + insertLen, deleteLen - insertLen);
        }
    }

    public synchronized void startTracking(IDocument doc) {
        this.stopTracking();
        this.fDocument = doc;
        if (this.fDocument != null) {
            this.fDocument.addPositionUpdater((IPositionUpdater)this);
        }
    }

    public synchronized void stopTracking() {
        if (this.fDocument != null) {
            this.fDocument.removePositionUpdater((IPositionUpdater)this);
            this.fDocument = null;
        }
    }

    public void dispose() {
        this.stopTracking();
    }
}

