/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.includes;

import com.ibm.icu.text.Collator;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.internal.corext.codemanipulation.IncludeInfo;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class SymbolExportMap {
    private static final String TAG_SYMBOL_EXPORT_MAPS = "maps";
    private static final String TAG_SYMBOL_EXPORT_MAP = "map";
    private static final String TAG_MAPPING = "mapping";
    private static final String TAG_KEY = "key";
    private static final String TAG_VALUE = "value";
    private static final Collator COLLATOR = Collator.getInstance();
    private final Map<String, Set<IncludeInfo>> map;

    public SymbolExportMap() {
        this.map = new HashMap<String, Set<IncludeInfo>>();
    }

    public SymbolExportMap(String[] keysAndValues) {
        if (keysAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("More keys than values");
        }
        this.map = new HashMap<String, Set<IncludeInfo>>(keysAndValues.length / 2);
        int i = 0;
        while (i < keysAndValues.length) {
            String key = keysAndValues[i++];
            this.addMapping(key, keysAndValues[i++]);
        }
    }

    public SymbolExportMap(SymbolExportMap other) {
        this.map = new HashMap<String, Set<IncludeInfo>>(other.map.size());
        this.addAllMappings(other);
    }

    protected void addMapping(String symbol, IncludeInfo header) {
        if (symbol.equals(header)) {
            return;
        }
        Set<IncludeInfo> list = this.map.get(symbol);
        if (list == null) {
            list = new LinkedHashSet<IncludeInfo>();
            this.map.put(symbol, list);
        }
        list.add(header);
    }

    public void addMapping(String symbol, String header) {
        this.addMapping(symbol, new IncludeInfo(header));
    }

    public Set<IncludeInfo> getMapping(String from) {
        Set<IncludeInfo> list = this.map.get(from);
        if (list == null) {
            return Collections.emptySet();
        }
        return list;
    }

    public Set<IncludeInfo> removeMapping(String symbol) {
        return this.map.remove(symbol);
    }

    public void saveToMemento(IMemento memento) {
        ArrayList<String> keys = new ArrayList<String>(this.map.keySet());
        Collections.sort(keys, COLLATOR);
        for (String key : keys) {
            ArrayList values = new ArrayList(this.map.get(key));
            Collections.sort(values);
            for (IncludeInfo value : values) {
                IMemento mapping = memento.createChild(TAG_MAPPING);
                mapping.putString(TAG_KEY, key);
                mapping.putString(TAG_VALUE, value.toString());
            }
        }
    }

    public static SymbolExportMap fromMemento(IMemento memento) {
        SymbolExportMap includeMap = new SymbolExportMap();
        IMemento[] iMementoArray = memento.getChildren(TAG_MAPPING);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento mapping = iMementoArray[n2];
            String key = mapping.getString(TAG_KEY);
            includeMap.addMapping(key, mapping.getString(TAG_VALUE));
            ++n2;
        }
        return includeMap;
    }

    public void addAllMappings(SymbolExportMap other) {
        for (Map.Entry<String, Set<IncludeInfo>> entry : other.map.entrySet()) {
            String source = entry.getKey();
            Set<IncludeInfo> otherTargets = entry.getValue();
            Set<IncludeInfo> targets = this.map.get(source);
            if (targets == null) {
                targets = new LinkedHashSet<IncludeInfo>(otherTargets);
                this.map.put(source, targets);
                continue;
            }
            targets.addAll(otherTargets);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        ArrayList<String> symbols = new ArrayList<String>(this.map.keySet());
        Collections.sort(symbols);
        for (String symbol : symbols) {
            buf.append('\n');
            buf.append(symbol);
            buf.append(" exported by ");
            ArrayList targets = new ArrayList(this.map.get(symbol));
            int i = 0;
            while (i < targets.size()) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(targets.get(i));
                ++i;
            }
        }
        return buf.toString();
    }

    public Map<String, Set<IncludeInfo>> getMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public static String serializeMaps(List<SymbolExportMap> maps) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)TAG_SYMBOL_EXPORT_MAPS);
        for (SymbolExportMap element : maps) {
            element.saveToMemento(memento.createChild(TAG_SYMBOL_EXPORT_MAP));
        }
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
        }
        catch (IOException e) {
            CUIPlugin.log(e);
        }
        return writer.toString();
    }

    public static List<SymbolExportMap> deserializeMaps(String str) {
        XMLMemento memento;
        StringReader reader = new StringReader(str);
        try {
            memento = XMLMemento.createReadRoot((Reader)reader);
        }
        catch (WorkbenchException e) {
            return Collections.emptyList();
        }
        ArrayList<SymbolExportMap> maps = new ArrayList<SymbolExportMap>();
        IMemento[] iMementoArray = memento.getChildren(TAG_SYMBOL_EXPORT_MAP);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento element = iMementoArray[n2];
            maps.add(SymbolExportMap.fromMemento(element));
            ++n2;
        }
        return maps;
    }
}

