/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeConstructorExpression;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.CHeuristicScanner;
import org.eclipse.cdt.internal.ui.text.contentassist.Lazy;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.contentassist.ContentAssistInvocationContext;
import org.eclipse.cdt.ui.text.contentassist.ICEditorContentAssistInvocationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class CContentAssistInvocationContext
extends ContentAssistInvocationContext
implements ICEditorContentAssistInvocationContext {
    private final IEditorPart fEditor;
    private final boolean fIsCompletion;
    private final boolean fIsAutoActivated;
    private IIndex fIndex;
    private boolean fIsContextInformationStyle;
    private int fAdjustedParseOffset = -1;
    private Lazy<Integer> fContextInfoPosition = new Lazy<Integer>(){

        @Override
        protected Integer calculateValue() {
            return CContentAssistInvocationContext.this.guessContextInformationPosition();
        }
    };
    private final Lazy<ITranslationUnit> fTU;
    private final Lazy<Integer> fParseOffset = new Lazy<Integer>(){

        @Override
        protected Integer calculateValue() {
            int result = this.doCalculate();
            if (result != CContentAssistInvocationContext.this.getInvocationOffset()) {
                CContentAssistInvocationContext.this.fIsContextInformationStyle = true;
            }
            CContentAssistInvocationContext.this.fAdjustedParseOffset = result;
            return result;
        }

        private int doCalculate() {
            if (CContentAssistInvocationContext.this.fIsCompletion) {
                return CContentAssistInvocationContext.this.guessCompletionPosition(CContentAssistInvocationContext.this.getInvocationOffset());
            }
            int contextInfoPosition = (Integer)CContentAssistInvocationContext.this.fContextInfoPosition.value();
            if (contextInfoPosition > 0) {
                return CContentAssistInvocationContext.this.guessCompletionPosition(contextInfoPosition);
            }
            return -1;
        }
    };
    private final Lazy<IASTCompletionNode> fCN = new Lazy<IASTCompletionNode>(){

        @Override
        protected IASTCompletionNode calculateValue() {
            int offset = CContentAssistInvocationContext.this.getParseOffset();
            if (offset < 0) {
                return null;
            }
            ICProject proj = CContentAssistInvocationContext.this.getProject();
            if (proj == null) {
                return null;
            }
            try {
                IASTCompletionNode adjusted;
                if (CContentAssistInvocationContext.this.fIndex != null) {
                    throw new IllegalStateException("The method should not be called multiple times.");
                }
                IIndexManager manager = CCorePlugin.getIndexManager();
                CContentAssistInvocationContext.this.fIndex = manager.getIndex(proj, 17);
                try {
                    CContentAssistInvocationContext.this.fIndex.acquireReadLock();
                }
                catch (InterruptedException e) {
                    CContentAssistInvocationContext.this.fIndex = null;
                }
                boolean parseNonIndexed = CUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.cdt.ui.editor.UseStructuralMode");
                int flags = parseNonIndexed ? 2 : 6;
                IASTCompletionNode result = ((ITranslationUnit)CContentAssistInvocationContext.this.fTU.value()).getCompletionNode(CContentAssistInvocationContext.this.fIndex, flags |= 0x20, offset);
                if (result != null && (adjusted = CContentAssistInvocationContext.this.adjustCompletionNode(result)) != null) {
                    CContentAssistInvocationContext.this.fIsContextInformationStyle = true;
                    result = adjusted;
                    if (adjusted.getNames().length > 0) {
                        IASTFileLocation adjustedLocation = adjusted.getNames()[0].getFileLocation();
                        CContentAssistInvocationContext.this.fAdjustedParseOffset = adjustedLocation.getNodeOffset() + adjustedLocation.getNodeLength();
                    }
                }
                return result;
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
                return null;
            }
        }
    };
    private final Lazy<Boolean> afterOpeningAngleBracket = new Lazy<Boolean>(){

        @Override
        protected Boolean calculateValue() {
            int parseOffset = CContentAssistInvocationContext.this.getParseOffset();
            int invocationOffset = CContentAssistInvocationContext.this.getInvocationOffset();
            CHeuristicScanner scanner = new CHeuristicScanner(CContentAssistInvocationContext.this.getDocument());
            int parenthesisOffset = scanner.findOpeningPeer(invocationOffset, parseOffset, '<', '>');
            if (parenthesisOffset != -1) {
                return true;
            }
            return false;
        }
    };
    private final Lazy<Boolean> afterOpeningParenthesisOrBrace = new Lazy<Boolean>(){

        @Override
        protected Boolean calculateValue() {
            int parenthesisOffset;
            int invocationOffset = CContentAssistInvocationContext.this.getInvocationOffset();
            int parseOffset = CContentAssistInvocationContext.this.fAdjustedParseOffset;
            int bound = Math.max(-1, parseOffset - 1);
            IDocument document = CContentAssistInvocationContext.this.getDocument();
            CHeuristicScanner scanner = new CHeuristicScanner(document);
            int start = invocationOffset;
            try {
                if (document.getChar(start) == ')' || document.getChar(start) == '}') {
                    --start;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if ((parenthesisOffset = scanner.findOpeningPeer(start, bound, '(', ')')) != -1) {
                return true;
            }
            int braceOffset = scanner.findOpeningPeer(start, bound, '{', '}');
            if (braceOffset != -1) {
                return true;
            }
            return false;
        }
    };
    private final Lazy<Boolean> inUsingDeclaration = new Lazy<Boolean>(){

        @Override
        protected Boolean calculateValue() {
            int offset;
            IDocument doc = CContentAssistInvocationContext.this.getDocument();
            CHeuristicScanner.TokenStream tokenStream = new CHeuristicScanner.TokenStream(doc, offset = Math.max(0, CContentAssistInvocationContext.this.getInvocationOffset() - 1));
            int token = tokenStream.previousToken();
            if (token == 2000) {
                token = tokenStream.previousToken();
            }
            while (token == 20) {
                token = tokenStream.previousToken();
                if (token == 1039) {
                    return true;
                }
                if (token != 2000) {
                    return false;
                }
                token = tokenStream.previousToken();
            }
            if (token == 1039) {
                return true;
            }
            return false;
        }
    };
    private final Lazy<Boolean> followedBySemicolon = new Lazy<Boolean>(){

        @Override
        protected Boolean calculateValue() {
            int offset;
            IDocument doc = CContentAssistInvocationContext.this.getDocument();
            CHeuristicScanner.TokenStream tokenStream = new CHeuristicScanner.TokenStream(doc, offset = CContentAssistInvocationContext.this.getInvocationOffset());
            int token = tokenStream.nextToken();
            if (token == 7) {
                return true;
            }
            return false;
        }
    };
    private final Lazy<Boolean> followedByOpeningParen = new Lazy<Boolean>(){

        @Override
        protected Boolean calculateValue() {
            int offset;
            IDocument doc = CContentAssistInvocationContext.this.getDocument();
            CHeuristicScanner.TokenStream tokenStream = new CHeuristicScanner.TokenStream(doc, offset = CContentAssistInvocationContext.this.getInvocationOffset());
            int token = tokenStream.nextToken();
            if (token == 5) {
                return true;
            }
            return false;
        }
    };
    private final Lazy<String> functionParameterDelimiter = new Lazy<String>(){

        @Override
        protected String calculateValue() {
            String propertyKey = "org.eclipse.cdt.core.formatter.insert_space_after_comma_in_method_declaration_parameters";
            Map options = CContentAssistInvocationContext.this.getProject().getOptions(true);
            return ((String)options.get(propertyKey)).equals("insert") ? ", " : ",";
        }
    };
    private final Lazy<String> templateParameterDelimiter = new Lazy<String>(){

        @Override
        protected String calculateValue() {
            String propertyKey = "org.eclipse.cdt.core.formatter.insert_space_after_comma_in_template_parameters";
            Map options = CContentAssistInvocationContext.this.getProject().getOptions(true);
            return ((String)options.get(propertyKey)).equals("insert") ? ", " : ",";
        }
    };

    private IASTName getAdjustedCompletionName(IASTName completionName) {
        if (completionName.getSimpleID().length > 0) {
            return null;
        }
        if (completionName.getParent() instanceof IASTIdExpression && completionName.getParent().getParent() instanceof IASTInitializerList) {
            IASTNode initList = completionName.getParent().getParent();
            if (initList.getParent() instanceof IASTDeclarator && initList.getParent().getParent() instanceof IASTSimpleDeclaration) {
                IASTSimpleDeclaration decl = (IASTSimpleDeclaration)completionName.getParent().getParent().getParent().getParent();
                if (decl.getDeclSpecifier() instanceof IASTNamedTypeSpecifier) {
                    return ((IASTNamedTypeSpecifier)decl.getDeclSpecifier()).getName();
                }
            } else if (initList.getParent() instanceof ICPPASTSimpleTypeConstructorExpression) {
                ICPPASTSimpleTypeConstructorExpression expr = (ICPPASTSimpleTypeConstructorExpression)initList.getParent();
                if (expr.getDeclSpecifier() instanceof IASTNamedTypeSpecifier) {
                    return ((IASTNamedTypeSpecifier)expr.getDeclSpecifier()).getName();
                }
            } else if (initList.getParent() instanceof ICPPASTConstructorChainInitializer) {
                ICPPASTConstructorChainInitializer ctorInit = (ICPPASTConstructorChainInitializer)initList.getParent();
                return ctorInit.getMemberInitializerId();
            }
        }
        return null;
    }

    private IASTCompletionNode adjustCompletionNode(IASTCompletionNode existing) {
        IASTName[] names = existing.getNames();
        if (names.length != 1) {
            return null;
        }
        IASTName completionName = names[0];
        IASTName newCompletionName = this.getAdjustedCompletionName(completionName);
        if (newCompletionName != null) {
            IToken newCompletionToken = null;
            try {
                newCompletionToken = newCompletionName.getSyntax();
            }
            catch (ExpansionOverlapsBoundaryException expansionOverlapsBoundaryException) {
                // empty catch block
            }
            if (newCompletionToken != null) {
                ASTCompletionNode newCompletionNode = new ASTCompletionNode(newCompletionToken, existing.getTranslationUnit());
                newCompletionNode.addName(newCompletionName);
                return newCompletionNode;
            }
        }
        return null;
    }

    public CContentAssistInvocationContext(ITextViewer viewer, int offset, IEditorPart editor, boolean isCompletion, boolean isAutoActivated) {
        super(viewer, offset);
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fIsCompletion = isCompletion;
        this.fIsContextInformationStyle = !isCompletion;
        this.fIsAutoActivated = isAutoActivated;
        this.fTU = new Lazy<ITranslationUnit>(){

            @Override
            protected ITranslationUnit calculateValue() {
                return CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(CContentAssistInvocationContext.this.fEditor.getEditorInput());
            }
        };
    }

    public CContentAssistInvocationContext(final ITranslationUnit unit, boolean isCompletion) {
        this.fTU = new Lazy<ITranslationUnit>(){

            @Override
            protected ITranslationUnit calculateValue() {
                return unit;
            }
        };
        this.fEditor = null;
        this.fIsCompletion = isCompletion;
        this.fIsContextInformationStyle = !isCompletion;
        this.fIsAutoActivated = false;
    }

    @Override
    public ITranslationUnit getTranslationUnit() {
        this.assertNotDisposed();
        return this.fTU.value();
    }

    @Override
    public ICProject getProject() {
        this.assertNotDisposed();
        ITranslationUnit unit = this.getTranslationUnit();
        return unit == null ? null : unit.getCProject();
    }

    @Override
    public IASTCompletionNode getCompletionNode() {
        this.assertNotDisposed();
        if (this.fEditor != null && this.fEditor instanceof CEditor) {
            CEditor editor = (CEditor)this.fEditor;
            if (!editor.shouldProcessLocalParsingCompletions()) {
                return null;
            }
            if (editor.isEnableScalablilityMode()) {
                if (editor.isParserBasedContentAssistDisabled()) {
                    return null;
                }
                if (this.isAutoActivated() && editor.isContentAssistAutoActivartionDisabled()) {
                    return null;
                }
            }
        }
        return this.fCN.value();
    }

    @Override
    public int getParseOffset() {
        this.assertNotDisposed();
        return this.fParseOffset.value();
    }

    public int getAdjustedParseOffset() {
        this.assertNotDisposed();
        return this.fAdjustedParseOffset;
    }

    @Override
    public int getContextInformationOffset() {
        this.assertNotDisposed();
        return this.fContextInfoPosition.value();
    }

    protected int guessCompletionPosition(int contextPosition) {
        this.assertNotDisposed();
        CHeuristicScanner scanner = new CHeuristicScanner(this.getDocument());
        int bound = Math.max(-1, contextPosition - 200);
        int pos = scanner.findNonWhitespaceBackward(contextPosition - 1, bound);
        if (pos == -1) {
            return contextPosition;
        }
        int token = scanner.previousToken(pos, bound);
        if (token == 11) {
            int openingAngleBracketPos;
            int openingParenthesisPos = scanner.findOpeningPeer(pos, bound, '(', ')');
            if ((pos = Math.max(openingParenthesisPos, openingAngleBracketPos = scanner.findOpeningPeer(pos, bound, '<', '>'))) == -1) {
                return contextPosition;
            }
            token = scanner.previousToken(pos, bound);
        }
        if (token == 5 || token == 13) {
            if ((pos = scanner.findNonWhitespaceBackward(pos - 1, bound)) == -1) {
                return contextPosition;
            }
            token = scanner.previousToken(pos, bound);
            if (token == 14) {
                if ((pos = scanner.findOpeningPeer(pos - 1, '<', '>')) == -1) {
                    return contextPosition;
                }
                if ((pos = scanner.findNonWhitespaceBackward(pos - 1, bound)) == -1) {
                    return contextPosition;
                }
                token = scanner.previousToken(pos, bound);
            }
            if (token == 2000) {
                return pos + 1;
            }
        }
        return contextPosition;
    }

    protected int guessContextInformationPosition() {
        int angle;
        int paren;
        int nearestPeer;
        this.assertNotDisposed();
        int contextPosition = this.getInvocationOffset();
        CHeuristicScanner scanner = new CHeuristicScanner(this.getDocument());
        int bound = Math.max(-1, contextPosition - 200);
        int pos = contextPosition - 1;
        while ((nearestPeer = Math.max(paren = scanner.findOpeningPeer(pos, bound, '(', ')'), angle = scanner.findOpeningPeer(pos, bound, '<', '>'))) != -1) {
            int token = scanner.previousToken(nearestPeer - 1, bound);
            if (token == 2000 || token == 14) {
                return nearestPeer + 1;
            }
            pos = nearestPeer - 1;
        }
        return -1;
    }

    @Override
    public IEditorPart getEditor() {
        this.assertNotDisposed();
        return this.fEditor;
    }

    @Override
    public boolean isContextInformationStyle() {
        this.assertNotDisposed();
        return this.fIsContextInformationStyle;
    }

    public boolean isAutoActivated() {
        this.assertNotDisposed();
        return this.fIsAutoActivated;
    }

    @Override
    public void dispose() {
        if (this.fIndex != null) {
            this.fIndex.releaseReadLock();
            this.fIndex = null;
        }
        super.dispose();
    }

    public boolean isAfterOpeningParenthesisOrBrace() {
        this.assertNotDisposed();
        return this.afterOpeningParenthesisOrBrace.value();
    }

    public boolean isAfterOpeningAngleBracket() {
        this.assertNotDisposed();
        return this.afterOpeningAngleBracket.value();
    }

    public boolean isInUsingDirective() {
        this.assertNotDisposed();
        return this.inUsingDeclaration.value();
    }

    public boolean isFollowedBySemicolon() {
        this.assertNotDisposed();
        return this.followedBySemicolon.value();
    }

    public boolean isFollowedByOpeningParen() {
        this.assertNotDisposed();
        return this.followedByOpeningParen.value();
    }

    public String getFunctionParameterDelimiter() {
        this.assertNotDisposed();
        return this.functionParameterDelimiter.value();
    }

    public String getTemplateParameterDelimiter() {
        this.assertNotDisposed();
        return this.templateParameterDelimiter.value();
    }
}

