/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetConfiguration;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetProjectConfiguration;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetProjectConfigurationController;
import org.eclipse.cdt.internal.ui.workingsets.ProjectConfigurationController;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetProjectConfiguration;
import org.eclipse.cdt.internal.ui.workingsets.WorkspaceSnapshot;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public interface IWorkingSetProjectConfigurationFactory {
    public String getID();

    public IWorkingSetProjectConfiguration createProjectConfiguration(IWorkingSetConfiguration var1, IProject var2);

    public IWorkingSetProjectConfigurationController createProjectConfigurationController(IWorkingSetProjectConfiguration.ISnapshot var1);

    public WorkspaceSnapshot.ProjectState createProjectState(IProject var1, ICProjectDescription var2);

    public static class Registry {
        private static final String EXT_PT_ID = "workingSetConfigurations";
        private static final String E_FACTORY = "projectConfigurationFactory";
        private static final String E_NATURE = "projectNature";
        private static final String A_ID = "id";
        private static final String A_CLASS = "class";
        public static Registry INSTANCE = new Registry();
        private final IWorkingSetProjectConfigurationFactory defaultFactory = new Default();
        private final Map<String, IWorkingSetProjectConfigurationFactory> factoriesByID = new HashMap<String, IWorkingSetProjectConfigurationFactory>();
        private final Map<String, IWorkingSetProjectConfigurationFactory> factoriesByNature = new HashMap<String, IWorkingSetProjectConfigurationFactory>();
        private Map<String, Set<String>> projectNaturePartOrdering = this.computeProjectNaturePartOrdering();

        private Registry() {
            this.loadExtensions();
        }

        public IWorkingSetProjectConfigurationFactory getFactory(String id) {
            IWorkingSetProjectConfigurationFactory result = this.get(this.factoriesByID, id);
            if (result == null) {
                result = this.defaultFactory;
            }
            return result;
        }

        public IWorkingSetProjectConfigurationFactory getFactory(IProject project) {
            IWorkingSetProjectConfigurationFactory result = null;
            String[] stringArray = this.getPartOrderedNatureIDs(project);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String nature = stringArray[n2];
                result = this.get(this.factoriesByNature, nature);
                if (result != null) break;
                ++n2;
            }
            return result;
        }

        private IWorkingSetProjectConfigurationFactory get(Map<?, IWorkingSetProjectConfigurationFactory> map, Object key) {
            return map.get(key);
        }

        private String[] getPartOrderedNatureIDs(IProject project) {
            String[] result;
            try {
                result = project.getDescription().getNatureIds();
            }
            catch (CoreException e) {
                CUIPlugin.log(e.getStatus());
                result = new String[]{};
            }
            String[] stringArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                String natureId = stringArray[n2];
                if (this.projectNaturePartOrdering.get(natureId) == null) {
                    this.projectNaturePartOrdering = this.computeProjectNaturePartOrdering();
                    break;
                }
                ++n2;
            }
            if (result.length > 0) {
                Arrays.sort(result, new Comparator<String>(){

                    @Override
                    public int compare(String nature1, String nature2) {
                        Set required1 = (Set)projectNaturePartOrdering.get(nature1);
                        Set required2 = (Set)projectNaturePartOrdering.get(nature2);
                        if (required1 != null && required1.contains(nature2)) {
                            return -1;
                        }
                        if (required2 != null && required2.contains(nature1)) {
                            return 1;
                        }
                        if (nature1.startsWith("org.eclipse.cdt.") && !nature2.startsWith("org.eclipse.cdt.")) {
                            return 1;
                        }
                        if (nature2.startsWith("org.eclipse.cdt.") && !nature1.startsWith("org.eclipse.cdt.")) {
                            return -1;
                        }
                        return 0;
                    }
                });
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        private Map<String, Set<String>> computeProjectNaturePartOrdering() {
            boolean loopAgain;
            void var4_7;
            HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IProjectNatureDescriptor[] iProjectNatureDescriptorArray = ws.getNatureDescriptors();
            int n = iProjectNatureDescriptorArray.length;
            boolean n2 = false;
            while (var4_7 < n) {
                IProjectNatureDescriptor next = iProjectNatureDescriptorArray[var4_7];
                result.put(next.getNatureId(), new HashSet<String>(Arrays.asList(next.getRequiredNatureIds())));
                ++var4_7;
            }
            do {
                loopAgain = false;
                for (Map.Entry entry : result.entrySet()) {
                    Set requireds = (Set)entry.getValue();
                    HashSet newRequireds = new HashSet(requireds);
                    boolean changed = false;
                    for (String required : requireds) {
                        changed |= newRequireds.addAll((Collection)result.get(required));
                    }
                    if (!changed) continue;
                    loopAgain = true;
                    entry.setValue(newRequireds);
                }
            } while (loopAgain);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadExtensions() {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtension[] iExtensionArray = registry.getExtensionPoint("org.eclipse.cdt.ui", EXT_PT_ID).getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (E_FACTORY.equals(element.getName())) {
                        try {
                            Descriptor desc = new Descriptor(element);
                            Map<String, IWorkingSetProjectConfigurationFactory> map = this.factoriesByID;
                            synchronized (map) {
                                this.factoriesByID.put(desc.getID(), desc);
                            }
                            map = this.factoriesByNature;
                            synchronized (map) {
                                IConfigurationElement[] iConfigurationElementArray2 = element.getChildren(E_NATURE);
                                int n5 = iConfigurationElementArray2.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    IConfigurationElement nature = iConfigurationElementArray2[n6];
                                    String natureID = nature.getAttribute(A_ID);
                                    if (natureID != null) {
                                        this.factoriesByNature.put(natureID, desc);
                                    } else {
                                        CUIPlugin.log(NLS.bind((String)WorkingSetMessages.WSProjConfigFactory_noNatureID, (Object)ext.getContributor().getName()), null);
                                    }
                                    ++n6;
                                }
                            }
                        }
                        catch (CoreException e) {
                            CUIPlugin.log(e.getStatus());
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        public static class Default
        implements IWorkingSetProjectConfigurationFactory,
        IExecutableExtension {
            private String id;

            @Override
            public IWorkingSetProjectConfiguration createProjectConfiguration(IWorkingSetConfiguration parent, IProject project) {
                WorkingSetProjectConfiguration result = this.createProjectConfiguration(parent);
                result.setProjectName(project.getName());
                return result;
            }

            protected WorkingSetProjectConfiguration createProjectConfiguration(IWorkingSetConfiguration parent) {
                return new WorkingSetProjectConfiguration(parent);
            }

            @Override
            public IWorkingSetProjectConfigurationController createProjectConfigurationController(IWorkingSetProjectConfiguration.ISnapshot config) {
                return new ProjectConfigurationController(config);
            }

            @Override
            public WorkspaceSnapshot.ProjectState createProjectState(IProject project, ICProjectDescription desc) {
                return new WorkspaceSnapshot.ProjectState(project, desc);
            }

            @Override
            public String getID() {
                return this.id;
            }

            public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
                this.id = config.getAttribute(Registry.A_ID);
            }
        }

        private class Descriptor
        implements IWorkingSetProjectConfigurationFactory {
            private final IConfigurationElement extension;
            private final String id;

            Descriptor(IConfigurationElement extension) throws CoreException {
                this.extension = extension;
                this.id = extension.getAttribute(Registry.A_ID);
                if (this.id == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", NLS.bind((String)WorkingSetMessages.WSProjConfigFactory_noFactoryID, (Object)extension.getContributor().getName())));
                }
            }

            @Override
            public String getID() {
                return this.id;
            }

            @Override
            public IWorkingSetProjectConfiguration createProjectConfiguration(IWorkingSetConfiguration parent, IProject project) {
                return this.resolve().createProjectConfiguration(parent, project);
            }

            @Override
            public IWorkingSetProjectConfigurationController createProjectConfigurationController(IWorkingSetProjectConfiguration.ISnapshot config) {
                return this.resolve().createProjectConfigurationController(config);
            }

            @Override
            public WorkspaceSnapshot.ProjectState createProjectState(IProject project, ICProjectDescription desc) {
                return this.resolve().createProjectState(project, desc);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private IWorkingSetProjectConfigurationFactory resolve() {
                IWorkingSetProjectConfigurationFactory result = null;
                try {
                    result = (IWorkingSetProjectConfigurationFactory)this.extension.createExecutableExtension(Registry.A_CLASS);
                }
                catch (ClassCastException e) {
                    CUIPlugin.log(NLS.bind((String)WorkingSetMessages.WSProjConfigFactory_badFactory, (Object)this.extension.getContributor().getName()), e);
                }
                catch (CoreException e) {
                    CUIPlugin.log((IStatus)new MultiStatus("org.eclipse.cdt.ui", 0, new IStatus[]{e.getStatus()}, WorkingSetMessages.WSProjConfigFactory_factoryFailed, null));
                }
                if (result == null) {
                    result = Registry.this.defaultFactory;
                }
                Map map = Registry.this.factoriesByID;
                synchronized (map) {
                    Registry.this.factoriesByID.put(this.getID(), result);
                }
                map = Registry.this.factoriesByNature;
                synchronized (map) {
                    for (Map.Entry entry : Registry.this.factoriesByNature.entrySet()) {
                        if (!((IWorkingSetProjectConfigurationFactory)entry.getValue()).getID().equals(this.getID())) continue;
                        entry.setValue(result);
                    }
                }
                return result;
            }
        }
    }
}

