/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.constant;

import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.constant.ConstantExpressionWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ConstantOptionsPage
extends WizardPage
implements SelectionListener {
    public static final Object NUMERIC_CONSTANT = "org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.NUMERIC_CONSTANT";
    public static final Object STRING_CONSTANT = "org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.STRING_CONSTANT";
    protected SQLQueryObject sqlStatement;
    private Composite mainPanel;
    private QueryValueExpression inputSQLExpression;
    private QueryValueExpression updatedSQLExpression;
    private Button numericConstantButton;
    private Button stringConstantButton;

    public ConstantOptionsPage(SQLQueryObject sqlStatementArg, QueryValueExpression sqlExpr) {
        super(Messages._UI_WIZARD_CONSTANT_OPTIONS_TITLE);
        this.setTitle(Messages._UI_WIZARD_CONSTANT_OPTIONS_HEADING);
        this.setDescription(Messages._UI_WIZARD_CONSTANT_OPTIONS_EXPL);
        this.sqlStatement = sqlStatementArg;
        this.updatedSQLExpression = this.inputSQLExpression = sqlExpr;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.mainPanel = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.mainPanel, "org.eclipse.datatools.sqltools.sqlbuilder.sqle0600");
        GridLayout mainPanelLayout = new GridLayout();
        this.mainPanel.setLayout((Layout)mainPanelLayout);
        this.mainPanel.setLayoutData((Object)ViewUtility.createFill());
        Group constantTypeGroup = new Group(this.mainPanel, 16);
        constantTypeGroup.setText(Messages._UI_GROUP_CONSTANT_TYPE);
        GridLayout constantTypeGroupLayout = new GridLayout();
        constantTypeGroup.setLayout((Layout)constantTypeGroupLayout);
        constantTypeGroup.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.numericConstantButton = new Button((Composite)constantTypeGroup, 16);
        this.numericConstantButton.setText(Messages._UI_RADIO_NUMERIC);
        this.numericConstantButton.addSelectionListener((SelectionListener)this);
        this.numericConstantButton.setSelection(true);
        this.stringConstantButton = new Button((Composite)constantTypeGroup, 16);
        this.stringConstantButton.setText(Messages._UI_RADIO_STRING);
        this.stringConstantButton.addSelectionListener((SelectionListener)this);
        this.setControl((Control)this.mainPanel);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent se) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.inputSQLExpression == null) {
                this.setPageComplete(false);
                if (this.getWizard() instanceof ExpressionBuilderWizard) {
                    ExpressionBuilderWizard wiz = (ExpressionBuilderWizard)this.getWizard();
                    wiz.setAllPagesComplete(false);
                } else if (this.getWizard() instanceof ConstantExpressionWizard) {
                    ConstantExpressionWizard wiz = (ConstantExpressionWizard)this.getWizard();
                    wiz.setConstantOptionsPageComplete(false);
                }
            } else {
                if (this.inputSQLExpression.getSQL().startsWith("'") || this.inputSQLExpression.getSQL().startsWith("X")) {
                    this.stringConstantButton.setSelection(true);
                } else {
                    this.numericConstantButton.setSelection(true);
                }
                this.setPageComplete(true);
                if (this.getWizard() instanceof ExpressionBuilderWizard) {
                    ExpressionBuilderWizard wiz = (ExpressionBuilderWizard)this.getWizard();
                    wiz.setAllPagesComplete(true);
                } else if (this.getWizard() instanceof ConstantExpressionWizard) {
                    ConstantExpressionWizard wiz = (ConstantExpressionWizard)this.getWizard();
                    wiz.setConstantOptionsPageComplete(true);
                }
            }
            ((WizardDialog)this.getContainer()).updateSize();
        }
    }

    public QueryValueExpression getSQLExpression() {
        return this.updatedSQLExpression;
    }

    public boolean canFlipToNextPage() {
        return this.stringConstantButton.getSelection() || this.numericConstantButton.getSelection();
    }

    public Object getConstantType() {
        Object type = this.numericConstantButton.getSelection() ? NUMERIC_CONSTANT : (this.stringConstantButton.getSelection() ? STRING_CONSTANT : "");
        return type;
    }
}

