/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.views.breakpoints.WorkingSetCategory;
import org.eclipse.debug.ui.AbstractBreakpointOrganizerDelegate;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class WorkingSetBreakpointOrganizer
extends AbstractBreakpointOrganizerDelegate
implements IPropertyChangeListener {
    IWorkingSetManager fWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();

    public WorkingSetBreakpointOrganizer() {
        this.fWorkingSetManager.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public IAdaptable[] getCategories(IBreakpoint breakpoint) {
        ArrayList<WorkingSetCategory> result = new ArrayList<WorkingSetCategory>();
        ArrayList<IResource> parents = new ArrayList<IResource>();
        IResource res = breakpoint.getMarker().getResource();
        parents.add(res);
        while (res != null) {
            if ((res = res.getParent()) == null) continue;
            parents.add(res);
        }
        IWorkingSet[] workingSets = this.fWorkingSetManager.getWorkingSets();
        int i = 0;
        while (i < workingSets.length) {
            if (!"org.eclipse.debug.ui.breakpointWorkingSet".equals(workingSets[i].getId())) {
                IAdaptable[] elements = workingSets[i].getElements();
                int j = 0;
                while (j < elements.length) {
                    IResource resource = (IResource)elements[j].getAdapter(IResource.class);
                    if (resource != null && parents.contains(resource)) {
                        result.add(new WorkingSetCategory(workingSets[i]));
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new IAdaptable[result.size()]);
    }

    @Override
    public void dispose() {
        this.fWorkingSetManager.removePropertyChangeListener((IPropertyChangeListener)this);
        this.fWorkingSetManager = null;
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        IWorkingSet set = null;
        if (event.getNewValue() instanceof IWorkingSet) {
            set = (IWorkingSet)event.getNewValue();
        } else if (event.getOldValue() instanceof IWorkingSet) {
            set = (IWorkingSet)event.getOldValue();
        }
        if (set != null && !"org.eclipse.debug.ui.breakpointWorkingSet".equals(set.getId())) {
            this.fireCategoryChanged((IAdaptable)new WorkingSetCategory(set));
        }
    }
}

