/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.EmfUtil;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.IViewEObjects;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.E;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.EmptyFilterOption;
import org.eclipse.e4.tools.emf.ui.internal.handlers.AbstractHandler;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class MarkDuplicateItemsBase
extends AbstractHandler {
    private String attName;

    @Execute
    public void execute(IEclipseContext context) {
        IViewEObjects viewer = (IViewEObjects)context.get("org.eclipse.e4.tools.active-object-viewer");
        Collection<EObject> duplicates = MarkDuplicateItemsBase.getDuplicateList(this.getAttName(), viewer.getAllEObjects());
        MarkDuplicateItemsBase.applyEmptyOption(duplicates, this.getAttName(), EmptyFilterOption.EXCLUDE);
        viewer.highlightEObjects(duplicates);
    }

    static Collection<EObject> getDuplicateList(String attName, Collection<EObject> all) {
        Map<String, List<EObject>> map = MarkDuplicateItemsBase.getDuplicateMap(attName, all);
        ArrayList<EObject> duplicates = new ArrayList<EObject>();
        for (String key : map.keySet()) {
            List<EObject> list = map.get(key);
            if (list.size() <= 1) continue;
            duplicates.addAll(list);
        }
        return duplicates;
    }

    static Map<String, List<EObject>> getDuplicateMap(String attName, Collection<EObject> selected) {
        ConcurrentHashMap<String, List<EObject>> map = new ConcurrentHashMap<String, List<EObject>>();
        for (EObject object : selected) {
            EObject item;
            EAttribute att;
            if (!(object instanceof EObject) || (att = EmfUtil.getAttribute(item = object, attName)) == null) continue;
            Object obj = item.eGet((EStructuralFeature)att);
            String attValue = obj == null ? "" : String.valueOf(obj);
            List<EObject> list = map.get(attValue);
            if (list == null) {
                list = new ArrayList<EObject>();
                map.put(attValue, list);
            }
            list.add(item);
        }
        return map;
    }

    public String getAttName() {
        return this.attName;
    }

    public void setAttributeName(String attName) {
        this.attName = attName;
    }

    protected static void applyEmptyOption(Collection<EObject> marked, String attName, EmptyFilterOption emptyFilterOption) {
        switch (emptyFilterOption) {
            case EXCLUDE: {
                Iterator<EObject> it = marked.iterator();
                while (it.hasNext()) {
                    EObject eObject = it.next();
                    if (!E.isEmpty(EmfUtil.getAttributeValue(eObject, attName))) continue;
                    it.remove();
                }
                break;
            }
            case ONLY: {
                Iterator<EObject> it = marked.iterator();
                while (it.hasNext()) {
                    EObject eObject = it.next();
                    if (!E.notEmpty(EmfUtil.getAttributeValue(eObject, attName))) continue;
                    it.remove();
                }
                break;
            }
        }
    }
}

