/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.op.FeatureListOperation;
import org.eclipse.egit.gitflow.op.FeatureTrackOperation;
import org.eclipse.egit.gitflow.ui.Activator;
import org.eclipse.egit.gitflow.ui.internal.JobFamilies;
import org.eclipse.egit.gitflow.ui.internal.UIText;
import org.eclipse.egit.gitflow.ui.internal.actions.GitFlowHandlerUtil;
import org.eclipse.egit.gitflow.ui.internal.dialogs.FeatureBranchSelectionDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class FeatureTrackHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        GitFlowRepository gfRepo = GitFlowHandlerUtil.getRepository(event);
        if (gfRepo == null) {
            return Activator.error(UIText.Handlers_noGitflowRepositoryFound);
        }
        ArrayList<Ref> refs = new ArrayList<Ref>();
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        int timeout = org.eclipse.egit.ui.Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
        FeatureListOperation featureListOperation = new FeatureListOperation(gfRepo, timeout);
        JobUtil.scheduleUserWorkspaceJob((IEGitOperation)featureListOperation, (String)UIText.FeatureTrackHandler_fetchingRemoteFeatures, (Object)JobFamilies.GITFLOW_FAMILY);
        IJobManager jobMan = Job.getJobManager();
        try {
            jobMan.join(JobFamilies.GITFLOW_FAMILY, null);
        }
        catch (InterruptedException | OperationCanceledException e) {
            return Activator.error(e.getMessage(), e);
        }
        List remoteFeatures = featureListOperation.getResult();
        if (remoteFeatures.isEmpty()) {
            MessageDialog.openInformation((Shell)activeShell, (String)UIText.FeatureTrackHandler_noRemoteFeatures, (String)UIText.FeatureTrackHandler_noRemoteFeaturesFoundOnTheConfiguredRemote);
        }
        refs.addAll(remoteFeatures);
        FeatureBranchSelectionDialog dialog = new FeatureBranchSelectionDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), refs, UIText.FeatureTrackHandler_ButtonOK, UIText.FeatureCheckoutHandler_selectFeature, UIText.FeatureTrackHandler_remoteFeatures, "refs/remotes/origin/" + gfRepo.getConfig().getFeaturePrefix(), gfRepo);
        if (dialog.open() != 0) {
            return Status.CANCEL_STATUS;
        }
        Ref ref = dialog.getSelectedNode();
        FeatureTrackOperation featureTrackOperation = new FeatureTrackOperation(gfRepo, ref, timeout);
        JobUtil.scheduleUserWorkspaceJob((IEGitOperation)featureTrackOperation, (String)UIText.FeatureTrackHandler_trackingFeature, (Object)JobFamilies.GITFLOW_FAMILY);
        return null;
    }
}

