/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.admin.protocol;

import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.admin.CDOAdminClientRepository;
import org.eclipse.emf.cdo.common.util.TransportException;
import org.eclipse.emf.cdo.internal.admin.CDOAdminClientImpl;
import org.eclipse.emf.cdo.internal.admin.protocol.CreateRepositoryRequest;
import org.eclipse.emf.cdo.internal.admin.protocol.DeleteRepositoryRequest;
import org.eclipse.emf.cdo.internal.admin.protocol.QueryRepositoriesRequest;
import org.eclipse.emf.cdo.internal.admin.protocol.RepositoryAddedIndication;
import org.eclipse.emf.cdo.internal.admin.protocol.RepositoryRemovedIndication;
import org.eclipse.emf.cdo.internal.admin.protocol.RepositoryReplicationProgressedIndication;
import org.eclipse.emf.cdo.internal.admin.protocol.RepositoryStateChangedIndication;
import org.eclipse.emf.cdo.internal.admin.protocol.RepositoryTypeChangedIndication;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.signal.SignalReactor;
import org.eclipse.net4j.signal.confirmation.ConfirmationIndication;
import org.eclipse.net4j.signal.security.AuthenticatingSignalProtocol;
import org.eclipse.net4j.signal.security.AuthenticationIndication;
import org.eclipse.net4j.util.confirmation.IConfirmationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOAdminClientProtocol
extends AuthenticatingSignalProtocol<CDOAdminClientImpl>
implements IConfirmationProvider.Provider {
    public CDOAdminClientProtocol(CDOAdminClientImpl admin) {
        super("cdo-admin");
        this.setInfraStructure(admin);
    }

    public Set<CDOAdminClientRepository> queryRepositories() {
        return this.send(new QueryRepositoriesRequest(this));
    }

    public boolean createRepository(String name, String type, Map<String, Object> properties) {
        return this.send(new CreateRepositoryRequest(this, name, type, properties), -1L);
    }

    public boolean deleteRepository(String name, String type) {
        return this.send(new DeleteRepositoryRequest(this, name, type), -1L);
    }

    protected SignalReactor createSignalReactor(short signalID) {
        switch (signalID) {
            case 4: {
                return new RepositoryAddedIndication(this);
            }
            case 5: {
                return new RepositoryRemovedIndication(this);
            }
            case 6: {
                return new RepositoryTypeChangedIndication(this);
            }
            case 7: {
                return new RepositoryStateChangedIndication(this);
            }
            case 8: {
                return new RepositoryReplicationProgressedIndication(this);
            }
            case 9: {
                return new AuthenticationIndication((AuthenticatingSignalProtocol)this, 9);
            }
            case 10: {
                return new ConfirmationIndication((SignalProtocol)this, 10);
            }
        }
        return super.createSignalReactor(signalID);
    }

    public IConfirmationProvider getConfirmationProvider() {
        return ((CDOAdminClientImpl)this.getInfraStructure()).getConfirmationProvider();
    }

    private <RESULT> RESULT send(RequestWithConfirmation<RESULT> request) {
        return this.send(request, this.getTimeout());
    }

    private <RESULT> RESULT send(RequestWithConfirmation<RESULT> request, long timeout) {
        try {
            return (RESULT)request.send(timeout);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TransportException((Throwable)ex);
        }
    }
}

