/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.repositories.CDORepositoryElement;
import org.eclipse.emf.cdo.explorer.ui.handlers.RepositoryCheckoutHandler;
import org.eclipse.emf.cdo.explorer.ui.handlers.RepositoryCheckoutHandlerQuick;
import org.eclipse.emf.cdo.internal.explorer.repositories.CDORepositoryImpl;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.net4j.util.ui.actions.LongRunningActionDelegate;

public class CheckoutCommitInfoActionDelegate
extends LongRunningActionDelegate {
    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        CDORepository repository;
        CDOCommitInfo commitInfo;
        CDOSession session;
        Object element;
        IStructuredSelection ssel;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && (ssel = (IStructuredSelection)selection).size() == 1 && (element = ssel.getFirstElement()) instanceof CDOCommitInfo && (session = CDOUtil.getSession((Object)(commitInfo = (CDOCommitInfo)element))) != null && (repository = (CDORepository)session.properties().get((Object)CDORepositoryImpl.REPOSITORY_KEY)) != null) {
            CDORepositoryElement repositoryElement = new CDORepositoryElement(){

                public CDORepository getRepository() {
                    return repository;
                }

                public int getBranchID() {
                    return commitInfo.getBranch().getID();
                }

                public long getTimeStamp() {
                    return commitInfo.getTimeStamp();
                }

                public CDOID getObjectID() {
                    return session.getRepositoryInfo().getRootResourceID();
                }
            };
            this.checkout(repositoryElement);
        }
    }

    protected void checkout(CDORepositoryElement repositoryElement) {
        RepositoryCheckoutHandler.checkout(this.getShell(), repositoryElement);
    }

    public static class Quick
    extends CheckoutCommitInfoActionDelegate {
        protected void checkout(CDORepositoryElement repositoryElement) {
            RepositoryCheckoutHandlerQuick.checkout(repositoryElement, "online-historical");
        }
    }
}

