/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DBIndexAnnotation {
    public static final String SOURCE_URI = "http://www.eclipse.org/CDO/DBIndex";
    public static final String FEATURES = "features";

    private DBIndexAnnotation() {
    }

    public static Set<List<EStructuralFeature>> getIndices(EClass eClass, EStructuralFeature[] allPersistentFeatures) {
        HashSet<List<EStructuralFeature>> indices = new HashSet<List<EStructuralFeature>>();
        for (EAnnotation annotation : EMFUtil.getAnnotations((EClass)eClass, (String)SOURCE_URI)) {
            EStructuralFeature feature;
            ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
            String featureNames = (String)annotation.getDetails().get((Object)FEATURES);
            if (featureNames != null && featureNames.length() != 0) {
                StringTokenizer tokenizer = new StringTokenizer(featureNames, ",");
                while (tokenizer.hasMoreTokens()) {
                    String featureName = tokenizer.nextToken().trim();
                    if (featureName.length() == 0) continue;
                    feature = DBIndexAnnotation.getPersistentFeature(featureName, allPersistentFeatures);
                    if (feature == null) {
                        OM.LOG.warn("Feature '" + (String)featureName + "' not found in class '" + eClass.getName() + "' in package '" + eClass.getEPackage().getNsURI() + "'");
                        continue;
                    }
                    features.add(feature);
                }
            } else {
                for (EObject reference : annotation.getReferences()) {
                    if (reference instanceof EStructuralFeature) {
                        feature = (EStructuralFeature)reference;
                        if (!DBIndexAnnotation.isPersistentFeature(feature, allPersistentFeatures)) {
                            OM.LOG.warn("Feature '" + feature.getName() + "' is not a persistent feature of class '" + eClass.getName() + "' in package '" + eClass.getEPackage().getNsURI() + "'");
                            continue;
                        }
                        features.add(feature);
                        continue;
                    }
                    OM.LOG.warn("Reference '" + reference + "' is not a feature");
                }
            }
            int size = features.size();
            if (size <= 0) continue;
            if (size > 1) {
                for (EStructuralFeature feature2 : features) {
                    if (!feature2.isMany()) continue;
                    OM.LOG.warn("Many-valued feature '" + feature2.getName() + "' not allowed in composed index on class '" + eClass.getName() + "' in package '" + eClass.getEPackage().getNsURI() + "'");
                }
            }
            indices.add(features);
        }
        EStructuralFeature[] eStructuralFeatureArray = allPersistentFeatures;
        int n = allPersistentFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature.getEAnnotation(SOURCE_URI) != null) {
                indices.add(Collections.singletonList(feature));
            }
            ++n2;
        }
        return indices;
    }

    private static EStructuralFeature getPersistentFeature(String featureName, EStructuralFeature[] allPersistentFeatures) {
        int i = 0;
        while (i < allPersistentFeatures.length) {
            EStructuralFeature feature = allPersistentFeatures[i];
            if (feature.getName().equals(featureName)) {
                return feature;
            }
            ++i;
        }
        return null;
    }

    private static boolean isPersistentFeature(EStructuralFeature feature, EStructuralFeature[] allPersistentFeatures) {
        int i = 0;
        while (i < allPersistentFeatures.length) {
            if (allPersistentFeatures[i] == feature) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

