/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.compare;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.internal.ui.dialogs.AbstractBranchPointDialog;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.compare.CDOCompareEditorUtil;
import org.eclipse.emf.cdo.ui.internal.compare.CompareActionDelegate;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Merge
extends CompareActionDelegate<CDOTransaction> {
    private final boolean allowTimeStamp;

    public Merge(boolean allowTimeStamp) {
        super(CDOTransaction.class);
        this.allowTimeStamp = allowTimeStamp;
    }

    @Override
    protected void run(List<CDOTransaction> targets, IProgressMonitor progressMonitor) {
        if (targets.size() == 1) {
            Shell shell = this.getTargetPart().getSite().getShell();
            CDOTransaction leftView = targets.get(0);
            CDOSession session = leftView.getSession();
            CDOBranchPoint branchPoint = AbstractBranchPointDialog.select((Shell)shell, (boolean)this.allowTimeStamp, (CDOBranchPoint)leftView);
            if (branchPoint != null) {
                final CDOView rightView = this.openView(session, branchPoint);
                final CDOView[] originView = new CDOView[1];
                CDOCompareEditorUtil.addDisposeRunnables(new Runnable(){

                    public void run() {
                        LifecycleUtil.deactivate((Object)originView[0]);
                        if (!rightView.isDirty()) {
                            LifecycleUtil.deactivate((Object)rightView);
                        }
                    }
                });
                CDOCompareEditorUtil.openEditor((CDOView)leftView, rightView, originView, true);
            }
        }
    }

    private CDOView openView(CDOSession session, CDOBranchPoint branchPoint) {
        if (branchPoint.getTimeStamp() == 0L) {
            return session.openTransaction(branchPoint.getBranch());
        }
        return session.openView(branchPoint);
    }

    public static class FromBranch
    extends Merge {
        public FromBranch() {
            super(false);
        }
    }

    public static class FromBranchPoint
    extends Merge {
        public FromBranchPoint() {
            super(true);
        }
    }
}

