/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.dialogs;

import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.ui.widgets.CommitHistoryComposite;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPage;

public class SelectCommitDialog
extends TitleAreaDialog {
    private static final String TITLE = "Select Commit";
    private final CDOSession session;
    private CommitHistoryComposite commitHistoryComposite;
    private CDOCommitInfo commitInfo;

    public SelectCommitDialog(IWorkbenchPage page, CDOSession session) {
        super(page.getWorkbenchWindow().getShell());
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x400 | 0x20 | 0x10);
        this.session = session;
    }

    public CDOSession getSession() {
        return this.session;
    }

    public final CDOCommitInfo getCommitInfo() {
        return this.commitInfo;
    }

    public final void setCommitInfo(CDOCommitInfo commitInfo) {
        this.commitInfo = commitInfo;
        this.validate();
    }

    protected Point getInitialSize() {
        return new Point(750, 600);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(TITLE);
        this.setTitle(TITLE);
        this.setTitleImage(SharedIcons.getImage((String)"wizban/commit.gif"));
        this.setMessage("Select a commit from the history.");
        Composite area = (Composite)super.createDialogArea(parent);
        GridLayout containerGridLayout = new GridLayout(1, false);
        containerGridLayout.marginWidth = 10;
        containerGridLayout.marginHeight = 10;
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)containerGridLayout);
        this.commitHistoryComposite = new CommitHistoryComposite(container, 2048){

            protected void commitInfoChanged(CDOCommitInfo commitInfo) {
                SelectCommitDialog.this.setCommitInfo(commitInfo);
            }

            protected void doubleClicked(CDOCommitInfo commitInfo) {
                SelectCommitDialog.this.close();
            }
        };
        this.commitHistoryComposite.setLayoutData(UIUtil.createGridData());
        this.commitHistoryComposite.setInput(new CommitHistoryComposite.Input(this.session, null, null));
        final Display display = parent.getDisplay();
        display.asyncExec(new Runnable(){
            private long end = System.currentTimeMillis() + 5000L;

            public void run() {
                if (!SelectCommitDialog.this.commitHistoryComposite.isDisposed()) {
                    Object data;
                    Table table = SelectCommitDialog.this.commitHistoryComposite.getTableViewer().getTable();
                    if (table.getItemCount() != 0 && (data = table.getItem(0).getData()) instanceof CDOCommitInfo) {
                        SelectCommitDialog.this.setCommitInfo((CDOCommitInfo)data);
                        table.select(0);
                        return;
                    }
                    if (System.currentTimeMillis() < this.end) {
                        display.asyncExec((Runnable)this);
                    }
                }
            }
        });
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validate();
    }

    protected void validate() {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(this.commitInfo != null);
        }
    }
}

