/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.policies;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.scopes.IFeaturedModelScope;
import org.eclipse.emf.diffmerge.structures.common.FHashSet;
import org.eclipse.emf.diffmerge.util.ModelImplUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

public class DefaultMergePolicy
implements IMergePolicy {
    @Override
    public boolean bindPresenceToOwnership(IFeaturedModelScope scope_p) {
        return true;
    }

    @Override
    public boolean copyExtrinsicIDs(IFeaturedModelScope sourceScope_p, IFeaturedModelScope targetScope_p) {
        return true;
    }

    @Override
    public boolean copyFeature(EStructuralFeature feature_p, IFeaturedModelScope scope_p) {
        return !feature_p.isDerived() && feature_p.isChangeable() && !FeatureMapUtil.isFeatureMap((EStructuralFeature)feature_p);
    }

    @Override
    public boolean copyOutOfScopeCrossReferences(IFeaturedModelScope sourceScope_p, IFeaturedModelScope targetScope_p) {
        return true;
    }

    public Set<EObject> getAdditionGroup(EObject element_p, IFeaturedModelScope scope_p) {
        FHashSet result = new FHashSet();
        for (EReference reference : element_p.eClass().getEAllReferences()) {
            if (!reference.isChangeable() || reference.isContainer() || scope_p.isContainment(reference) && this.bindPresenceToOwnership(scope_p) || !this.isMandatoryForAddition(reference)) continue;
            result.addAll(scope_p.get(element_p, reference));
        }
        return result;
    }

    public Set<EObject> getDeletionGroup(EObject element_p, IFeaturedModelScope scope_p) {
        FHashSet result = new FHashSet();
        for (EReference reference : element_p.eClass().getEAllReferences()) {
            if (!reference.isChangeable() || reference.isContainer() || scope_p.isContainment(reference) && this.bindPresenceToOwnership(scope_p) || !this.isMandatoryForDeletion(reference)) continue;
            result.addAll(scope_p.get(element_p, reference));
        }
        return result;
    }

    @Override
    public int getDesiredValuePosition(IComparison comparison_p, Role destination_p, IMatch source_p, EReference reference_p, EObject sourceValue_p) {
        EObject sourceHolder = source_p.get(destination_p.opposite());
        EObject destinationHolder = source_p.get(destination_p);
        if (sourceHolder != null && destinationHolder != null && sourceValue_p != null) {
            int start;
            List<EObject> sourceValues = comparison_p.getScope(destination_p.opposite()).get(sourceHolder, reference_p);
            List<EObject> destinationValues = comparison_p.getScope(destination_p).get(destinationHolder, reference_p);
            int i = start = sourceValues.indexOf(sourceValue_p) + 1;
            while (i < sourceValues.size()) {
                int nextDestinationIndex;
                EObject nextDestinationElement;
                EObject nextSourceElement = sourceValues.get(i);
                IMatch nextMatch = comparison_p.getMapping().getMatchFor(nextSourceElement, destination_p.opposite());
                if (nextMatch != null && (nextDestinationElement = nextMatch.get(destination_p)) != null && (nextDestinationIndex = destinationValues.indexOf(nextDestinationElement)) >= 0) {
                    return nextDestinationIndex;
                }
                ++i;
            }
        }
        return -1;
    }

    protected String getNewIntrinsicID(EObject element_p, IFeaturedModelScope scope_p) {
        return null;
    }

    @Override
    public boolean isMandatoryForAddition(EReference reference_p) {
        return this.isSingleMandatory(reference_p);
    }

    @Override
    public boolean isMandatoryForDeletion(EReference reference_p) {
        EReference opposite = reference_p.getEOpposite();
        return opposite != null && this.isSingleMandatory(opposite);
    }

    protected boolean isSingleMandatory(EReference reference_p) {
        return !reference_p.isMany() && reference_p.getLowerBound() > 0;
    }

    protected boolean requiresNewIntrinsicID(EObject element_p, IFeaturedModelScope scope_p) {
        return false;
    }

    @Override
    public void setIntrinsicID(EObject source_p, IFeaturedModelScope sourceScope_p, EObject target_p, IFeaturedModelScope targetScope_p) {
        if (this.requiresNewIntrinsicID(target_p, targetScope_p)) {
            String newID = this.getNewIntrinsicID(target_p, targetScope_p);
            ModelImplUtil.setIntrinsicID(target_p, newID);
        }
    }
}

