/**
 * Copyright (c) 2011-2016 EclipseSource Muenchen GmbH and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * EclipseSource Munich - initial API and implementation
 */
package org.eclipse.emf.ecp.view.template.style.tableStyleProperty.model.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecp.view.template.model.VTTemplatePackage;
import org.eclipse.emf.ecp.view.template.style.tableStyleProperty.model.RenderMode;
import org.eclipse.emf.ecp.view.template.style.tableStyleProperty.model.VTTableStyleProperty;
import org.eclipse.emf.ecp.view.template.style.tableStyleProperty.model.VTTableStylePropertyFactory;
import org.eclipse.emf.ecp.view.template.style.tableStyleProperty.model.VTTableStylePropertyPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * 
 * @generated
 */
public class VTTableStylePropertyPackageImpl extends EPackageImpl implements VTTableStylePropertyPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass tableStylePropertyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EEnum renderModeEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>
	 * Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.emf.ecp.view.template.style.tableStyleProperty.model.VTTableStylePropertyPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private VTTableStylePropertyPackageImpl() {
		super(eNS_URI, VTTableStylePropertyFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>
	 * This method is used to initialize {@link VTTableStylePropertyPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static VTTableStylePropertyPackage init() {
		if (isInited) {
			return (VTTableStylePropertyPackage) EPackage.Registry.INSTANCE
				.getEPackage(VTTableStylePropertyPackage.eNS_URI);
		}

		// Obtain or create and register package
		final VTTableStylePropertyPackageImpl theTableStylePropertyPackage = (VTTableStylePropertyPackageImpl) (EPackage.Registry.INSTANCE
			.get(eNS_URI) instanceof VTTableStylePropertyPackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI)
				: new VTTableStylePropertyPackageImpl());

		isInited = true;

		// Initialize simple dependencies
		VTTemplatePackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theTableStylePropertyPackage.createPackageContents();

		// Initialize created meta-data
		theTableStylePropertyPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theTableStylePropertyPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(VTTableStylePropertyPackage.eNS_URI, theTableStylePropertyPackage);
		return theTableStylePropertyPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getTableStyleProperty() {
		return tableStylePropertyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getTableStyleProperty_MinimumHeight() {
		return (EAttribute) tableStylePropertyEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getTableStyleProperty_MaximumHeight() {
		return (EAttribute) tableStylePropertyEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getTableStyleProperty_ShowValidationSummaryTooltip() {
		return (EAttribute) tableStylePropertyEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getTableStyleProperty_EnableSorting() {
		return (EAttribute) tableStylePropertyEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getTableStyleProperty_VisibleLines() {
		return (EAttribute) tableStylePropertyEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getTableStyleProperty_RenderMode() {
		return (EAttribute) tableStylePropertyEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EEnum getRenderMode() {
		return renderModeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public VTTableStylePropertyFactory getTableStylePropertyFactory() {
		return (VTTableStylePropertyFactory) getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package. This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) {
			return;
		}
		isCreated = true;

		// Create classes and their features
		tableStylePropertyEClass = createEClass(TABLE_STYLE_PROPERTY);
		createEAttribute(tableStylePropertyEClass, TABLE_STYLE_PROPERTY__MINIMUM_HEIGHT);
		createEAttribute(tableStylePropertyEClass, TABLE_STYLE_PROPERTY__MAXIMUM_HEIGHT);
		createEAttribute(tableStylePropertyEClass, TABLE_STYLE_PROPERTY__SHOW_VALIDATION_SUMMARY_TOOLTIP);
		createEAttribute(tableStylePropertyEClass, TABLE_STYLE_PROPERTY__ENABLE_SORTING);
		createEAttribute(tableStylePropertyEClass, TABLE_STYLE_PROPERTY__VISIBLE_LINES);
		createEAttribute(tableStylePropertyEClass, TABLE_STYLE_PROPERTY__RENDER_MODE);

		// Create enums
		renderModeEEnum = createEEnum(RENDER_MODE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model. This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) {
			return;
		}
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		final VTTemplatePackage theTemplatePackage = (VTTemplatePackage) EPackage.Registry.INSTANCE
			.getEPackage(VTTemplatePackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		tableStylePropertyEClass.getESuperTypes().add(theTemplatePackage.getStyleProperty());

		// Initialize classes, features, and operations; add parameters
		initEClass(tableStylePropertyEClass, VTTableStyleProperty.class, "TableStyleProperty", !IS_ABSTRACT, //$NON-NLS-1$
			!IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getTableStyleProperty_MinimumHeight(), ecorePackage.getEInt(), "minimumHeight", null, 0, 1, //$NON-NLS-1$
			VTTableStyleProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
			!IS_DERIVED, IS_ORDERED);
		initEAttribute(getTableStyleProperty_MaximumHeight(), ecorePackage.getEInt(), "maximumHeight", null, 0, 1, //$NON-NLS-1$
			VTTableStyleProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
			!IS_DERIVED, IS_ORDERED);
		initEAttribute(getTableStyleProperty_ShowValidationSummaryTooltip(), ecorePackage.getEBoolean(),
			"showValidationSummaryTooltip", null, 0, 1, VTTableStyleProperty.class, !IS_TRANSIENT, !IS_VOLATILE, //$NON-NLS-1$
			IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTableStyleProperty_EnableSorting(), ecorePackage.getEBoolean(), "enableSorting", "true", 0, 1, //$NON-NLS-1$ //$NON-NLS-2$
			VTTableStyleProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
			!IS_DERIVED, IS_ORDERED);
		initEAttribute(getTableStyleProperty_VisibleLines(), ecorePackage.getEInt(), "visibleLines", null, 0, 1, //$NON-NLS-1$
			VTTableStyleProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
			!IS_DERIVED, IS_ORDERED);
		initEAttribute(getTableStyleProperty_RenderMode(), getRenderMode(), "renderMode", null, 0, 1, //$NON-NLS-1$
			VTTableStyleProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
			!IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(renderModeEEnum, RenderMode.class, "RenderMode"); //$NON-NLS-1$
		addEEnumLiteral(renderModeEEnum, RenderMode.DEFAULT);
		addEEnumLiteral(renderModeEEnum, RenderMode.COMPACT_VERTICALLY);

		// Create resource
		createResource(eNS_URI);
	}

} // VTTableStylePropertyPackageImpl
