/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.replacement;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.internal.common.MetamodelFactory;
import org.eclipse.emf.edapt.internal.common.MetamodelUtils;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="enumerationToSubClasses", label="Enumeration to Sub Classes", description="In the metamodel, an enumeration attribute of a class is replaced by subclasses. The class is made abstract, and a subclass is created for each literal of the enumeration. The enumeration attribute is deleted and also the enumeration, if not used otherwise. In the model, instances the class are migrated to the appropriate subclass according to the value of the enumeration attribute.", breaking=true)
public class EnumerationToSubClasses
extends OperationImplementation {
    @EdaptParameter(main=true, description="The enumeration attribute")
    public EAttribute enumAttribute;
    @EdaptParameter(description="The package in which the subclasses are created")
    public EPackage ePackage;

    @EdaptConstraint(description="The type of the attribute must be an enumeration")
    public boolean checkAttributeTypeEnum() {
        return this.enumAttribute.getEType() instanceof EEnum;
    }

    @EdaptConstraint(description="The context class must not have sub types")
    public boolean checkContextClassNoSubTypes(Metamodel metamodel) {
        EClass contextClass = this.enumAttribute.getEContainingClass();
        return metamodel.getESubTypes(contextClass).isEmpty();
    }

    @EdaptConstraint(description="The context class must be concrete")
    public boolean checkContextClassConcrete() {
        EClass contextClass = this.enumAttribute.getEContainingClass();
        return MetamodelUtils.isConcrete((EClass)contextClass);
    }

    @Override
    public void initialize(Metamodel metamodel) {
        if (this.ePackage == null) {
            this.ePackage = this.enumAttribute.getEContainingClass().getEPackage();
        }
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        EClass contextClass = this.enumAttribute.getEContainingClass();
        EEnum enumeration = (EEnum)this.enumAttribute.getEAttributeType();
        ArrayList<EClass> subClasses = new ArrayList<EClass>();
        for (EEnumLiteral literal : enumeration.getELiterals()) {
            EClass subClass = MetamodelFactory.newEClass((EPackage)this.ePackage, (String)literal.getName(), (EClass)contextClass);
            subClasses.add(subClass);
        }
        metamodel.delete((EModelElement)this.enumAttribute);
        if (metamodel.getInverse((EModelElement)enumeration, EcorePackage.Literals.EATTRIBUTE__EATTRIBUTE_TYPE).isEmpty()) {
            metamodel.delete((EModelElement)enumeration);
        }
        contextClass.setAbstract(true);
        for (Instance instance : model.getInstances(contextClass)) {
            Object value = instance.unset((EStructuralFeature)this.enumAttribute);
            int index = enumeration.getELiterals().indexOf(value);
            instance.migrate((EClass)subClasses.get(index));
        }
    }
}

