/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EEFRuntimePlugin
extends AbstractUIPlugin {
    public static final String ICONS_16x16 = "icons/16x16/";
    public static final String PLUGIN_ID = "org.eclipse.emf.eef.runtime";
    private static EEFRuntimePlugin plugin;
    private static AdapterFactory adapterFactory;
    private static Diagnostician diagnostician;
    private static ImageRegistry imageRegistry;

    static {
        imageRegistry = null;
    }

    public Image getRegisteredImage(String key) {
        return this.getImageRegistry().get(key);
    }

    public void registerImage(String key, String path) {
        if (this.getImageRegistry().get(key) != null) {
            this.getImageRegistry().remove(key);
        }
        this.getImageRegistry().put(key, ImageDescriptor.createFromFile(null, (String)path));
    }

    public ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    public EEFRuntimePlugin() {
        plugin = this;
        adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        diagnostician = new Diagnostician(){

            protected boolean doValidateContents(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                return true;
            }
        };
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (imageRegistry != null) {
            imageRegistry.dispose();
        }
        super.stop(context);
    }

    public static EEFRuntimePlugin getDefault() {
        return plugin;
    }

    public AdapterFactory getAdapterFactory() {
        return adapterFactory;
    }

    public static Diagnostician getEEFValidator() {
        return diagnostician;
    }

    public void logError(String msg, Exception e) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, msg, (Throwable)e));
    }

    public static Image getImage(String key) {
        ImageRegistry registry = EEFRuntimePlugin.getDefault().getImageRegistry();
        Image image = registry.get(key);
        if (image == null) {
            ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)key);
            registry.put(key, desc);
            image = registry.get(key);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)key);
    }
}

