/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.views;

import java.text.MessageFormat;
import java.util.concurrent.Callable;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.client.ESWorkspaceProvider;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.KeyStoreManager;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESServerImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESWorkspaceImpl;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.views.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.views.NewRepositoryWizardPageOne;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class NewRepositoryWizard
extends Wizard
implements INewWizard {
    private ESServer server;
    private NewRepositoryWizardPageOne mainPage;
    private boolean isEdit;

    public NewRepositoryWizard() {
    }

    public NewRepositoryWizard(ESServer server) {
        this.server = server;
        this.isEdit = true;
    }

    public void addPages() {
        this.mainPage = new NewRepositoryWizardPageOne();
        this.setWindowTitle(Messages.NewRepositoryWizard_Server_Details);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean canFinish() {
        return true;
    }

    private void invalidateSessions(ESWorkspaceImpl workspace) throws ESException {
        for (Usersession session : ((Workspace)workspace.toInternalAPI()).getUsersessions()) {
            if (session.getServerInfo() != ((ESServerImpl)ESServerImpl.class.cast(this.server)).toInternalAPI()) continue;
            session.logout();
            session.setSavePassword(false);
            session.setPassword(null);
            session.setPersistentPassword(null);
        }
        ((Workspace)workspace.toInternalAPI()).save();
    }

    public boolean performFinish() {
        if (this.mainPage.canFlipToNextPage()) {
            final ESWorkspaceImpl workspace = (ESWorkspaceImpl)ESWorkspaceProvider.INSTANCE.getWorkspace();
            final ESServer editedServer = this.mainPage.getServer();
            if (this.isEdit) {
                RunESCommand.run((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        NewRepositoryWizard.this.server.setCertificateAlias(editedServer.getCertificateAlias());
                        NewRepositoryWizard.this.server.setName(editedServer.getName());
                        NewRepositoryWizard.this.server.setPort(editedServer.getPort());
                        NewRepositoryWizard.this.server.setURL(editedServer.getURL());
                        NewRepositoryWizard.this.invalidateSessions(workspace);
                        KeyStoreManager.getInstance().setDefaultCertificate(editedServer.getCertificateAlias());
                        return null;
                    }
                });
            } else if (workspace.serverExists(editedServer)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.NewRepositoryWizard_Server_Already_Exists_Title, (String)MessageFormat.format(Messages.NewRepositoryWizard_Server_Already_Exists_Message, String.valueOf(this.server.getName()) + ":" + this.server.getPort()));
            } else {
                workspace.addServer(editedServer);
            }
        } else {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.NewRepositoryWizard_Blank_Fields_Title, (String)Messages.NewRepositoryWizard_Blank_Fields_Message);
            return false;
        }
        this.dispose();
        return true;
    }

    public ESServer getServer() {
        if (this.server == null) {
            this.server = ESServer.FACTORY.createServer("localhost", 8080, "emfstore test certificate (do not use in production!)");
        }
        return this.server;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

