/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.metamodel.v0_2_0.custompt;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Alignment implements Enumerator
{
    LEFT(0, "LEFT", "LEFT"),
    CENTER(1, "CENTER", "CENTER"),
    RIGHT(2, "RIGHT", "RIGHT");

    public static final int LEFT_VALUE = 0;
    public static final int CENTER_VALUE = 1;
    public static final int RIGHT_VALUE = 2;
    private static final Alignment[] VALUES_ARRAY;
    public static final List<Alignment> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Alignment[]{LEFT, CENTER, RIGHT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Alignment get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Alignment result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Alignment getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Alignment result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Alignment get(int value) {
        switch (value) {
            case 0: {
                return LEFT;
            }
            case 1: {
                return CENTER;
            }
            case 2: {
                return RIGHT;
            }
        }
        return null;
    }

    private Alignment(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

