/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.celleditors.internal;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.celleditors.internal.Activator;
import org.eclipse.emf.facet.widgets.celleditors.modelCellEditor.AbstractModelCellEditor;

public class ModelCellEditor {
    private final String bundleName;
    private final AbstractModelCellEditor modelCellEditor;

    public ModelCellEditor(String bundleName, AbstractModelCellEditor modelCellEditor) {
        this.bundleName = bundleName;
        this.modelCellEditor = modelCellEditor;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public String getCellID() {
        return this.modelCellEditor.getCellId();
    }

    public AbstractModelCellEditor getModelCellEditor() {
        return this.modelCellEditor;
    }

    public Object getCellEditorImplementation() {
        String className = this.modelCellEditor.getModelCellEditorImpl();
        Class classInstance = null;
        try {
            classInstance = Platform.getBundle((String)this.bundleName).loadClass(className);
        }
        catch (Exception exception) {
            Logger.logError((String)("Could not find class: " + className), (Plugin)Activator.getDefault());
            return null;
        }
        Object instance = null;
        try {
            instance = classInstance.newInstance();
        }
        catch (Exception exception) {
            Logger.logError((String)("Could not instantiate class: " + className), (Plugin)Activator.getDefault());
            return null;
        }
        return instance;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelCellEditor) {
            ModelCellEditor other = (ModelCellEditor)obj;
            return other.getCellID().equals(this.getCellID());
        }
        return false;
    }

    public int hashCode() {
        return this.getCellID().hashCode();
    }

    public String toString() {
        return String.valueOf(this.getBundleName()) + "#" + this.getCellID();
    }
}

