/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.core.ICustomizationManagerFactory;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.ui.IContentPropertiesHandler;
import org.eclipse.emf.facet.custom.ui.IContentPropertiesHandlerFactory;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProviderFactory;
import org.eclipse.emf.facet.custom.ui.ISelectionPropertiesHandler;
import org.eclipse.emf.facet.custom.ui.ISelectionPropertiesHandlerFactory;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.ui.internal.exported.dialog.IETypedElementSelectionDialog;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.util.emf.core.CommandFactory;
import org.eclipse.emf.facet.util.emf.core.command.ILockableUndoCommand;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactoriesRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TableFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TablePackage;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.InstantiationMethod;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.command.ITableCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ColumnSortDirection;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetView;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetViewFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.TableWidgetUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.dialog.IAllowedContentsETypedElementSelectionDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.dialog.IColumnsToHideDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.TableWidgetRuntimeException;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.DropService;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.EmptyWidgetComposite;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.MetaClassCache;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.ModelChangedListener;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.SelectionService;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.TableChangedListener;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.TableWidgetSelectionProvider;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.column.ColumnsAddService;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.column.ColumnsHideService;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.column.SortService;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.BasicCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.TableCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.emf.listener.RowDeleteCommandStackListener;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.emf.listener.RowDeleteTriggerListener;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.CustomizationUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.FacetAndCustomService;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.FacetsUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.LocalCustomCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.instantiation.InstantiationMethodService;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.presentable.PresentableService;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.utils.EditingDomainUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.utils.ResourceUtils;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableWidget
implements ITableWidgetInternal {
    protected static final boolean DEBUG_EVENTS = DebugUtils.getDebugStatus((Plugin)Activator.getDefault(), (String)"events");
    protected static final boolean DEBUG_RESOURCE_LISTENER = DebugUtils.getDebugStatus((Plugin)Activator.getDefault(), (String)"resource_listener");
    private static final boolean DEBUG_SET_FACET = DebugUtils.getDebugStatus((Plugin)Activator.getDefault(), (String)"setFacet");
    protected static final boolean DEBUG_SELECTION = DebugUtils.getDebugStatus((Plugin)Activator.getDefault(), (String)"selection");
    protected static final boolean DEBUG_SORT = DebugUtils.getDebugStatus((Plugin)Activator.getDefault(), (String)"sort");
    private static final int REFRESH_JOB_DELAY = 100;
    private final Table tableInstance;
    private ICustomizedLabelProvider tableLabelProvider;
    private final Collection<ISelectionChangedListener> fSelectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    private final ModelChangedListener modelChangedLstnr;
    private final TableChangedListener tableChangedLstnr;
    private final ICustomizationManager customizationEngine;
    private final MetaClassCache metaClassCache;
    private final Resource resource;
    private final MenuManager menuMgr;
    private final boolean dataEditable;
    private final EditingDomain editingDomain;
    private final transient ICommandFactory commandFactory;
    private final ITableWidgetView composite;
    private final IFacetManager facetManager;
    private final List<IActionDelegate> actionList = new ArrayList<IActionDelegate>();
    private final IContentPropertiesHandler contentPropertiesHandler;
    private final ISelectionPropertiesHandler selectionPropertiesHandler;
    private final SelectionService selectionService;
    private boolean disposed;
    private final TableWidgetSelectionProvider selectionProvider;
    private final Composite parent;
    private final LocalCustomCommandFactory localCustoCmdFactory;
    private final TableCommandFactory tableCmdFactory;
    private final PresentableService presentableSrvc;
    private final SortService sortSrvc;
    private final FacetAndCustomService facetAndCustomSrvc;
    private final ColumnsAddService columnsAddSrvc;
    private final ColumnsHideService columnsHideSrvc;
    private final DropService dropSrvc;
    private final InstantiationMethodService initMethodSrvc;
    private final Job refreshJob = new Job("Refresh EMF Facet Table"){

        protected IStatus run(IProgressMonitor monitor) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    DebugUtils.debug((boolean)DEBUG_EVENTS, (String)"Refresh job execution.");
                    if (!TableWidget.this.isDisposed()) {
                        TableWidget.this.reset();
                    }
                }
            });
            return Status.OK_STATUS;
        }
    };

    public TableWidget(Composite parent, IEditingDomainProvider editingDomainProvider, Table tableInstanceParam, MenuManager menuMgr, ITableWidgetViewFactory compositeFactory) {
        this.parent = parent;
        this.composite = tableInstanceParam == null || tableInstanceParam.getRows().isEmpty() ? new EmptyWidgetComposite(parent) : compositeFactory.createTableView(parent, this);
        this.menuMgr = menuMgr;
        this.editingDomain = EditingDomainUtils.initEditingDomain(editingDomainProvider);
        this.dataEditable = !EditingDomainUtils.isEditingDomainProviderNotInitialized(editingDomainProvider);
        this.tableInstance = this.initTable(tableInstanceParam);
        this.resource = this.initResource();
        this.commandFactory = ICommandFactoriesRegistry.INSTANCE.getCommandFactoryFor(this.editingDomain);
        this.facetManager = IFacetManagerFactory.DEFAULT.getOrCreateDefaultFacetManager(this.resource.getResourceSet());
        this.customizationEngine = ICustomizationManagerFactory.DEFAULT.createICustomizationManager(this.facetManager);
        this.contentPropertiesHandler = IContentPropertiesHandlerFactory.DEFAULT.createIContentPropertiesHandler(this.customizationEngine);
        this.tableCmdFactory = new TableCommandFactory(this.tableInstance, this.editingDomain, (org.eclipse.emf.facet.util.emf.core.internal.exported.ICommandFactory)this.commandFactory);
        BasicCommandFactory basicCmdFactory = new BasicCommandFactory((org.eclipse.emf.facet.util.emf.core.internal.exported.ICommandFactory)this.commandFactory, this.editingDomain);
        this.localCustoCmdFactory = new LocalCustomCommandFactory(this.tableInstance, basicCmdFactory);
        this.facetAndCustomSrvc = new FacetAndCustomService(this.tableInstance, basicCmdFactory);
        this.columnsAddSrvc = new ColumnsAddService(this.tableInstance, basicCmdFactory);
        this.columnsHideSrvc = new ColumnsHideService(this.tableInstance, basicCmdFactory);
        this.presentableSrvc = new PresentableService(this.tableInstance, basicCmdFactory, this.tableCmdFactory);
        this.sortSrvc = new SortService(this.tableInstance, basicCmdFactory);
        this.dropSrvc = new DropService(this.presentableSrvc, this.editingDomain, this.tableCmdFactory);
        this.initMethodSrvc = new InstantiationMethodService(this.tableInstance, this.tableCmdFactory, this.editingDomain);
        this.selectionPropertiesHandler = ISelectionPropertiesHandlerFactory.DEFAULT.createSelectionPropertiesHandler(this.customizationEngine);
        this.metaClassCache = new MetaClassCache(this.tableInstance);
        this.reset();
        this.selectionProvider = new TableWidgetSelectionProvider(this.composite, this.customizationEngine, this.tableInstance);
        this.selectionService = new SelectionService(this.selectionProvider, this.facetManager);
        this.composite.asComposite().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                TableWidget.this.onWidgetDisposed();
            }
        });
        this.tableChangedLstnr = this.initTableChangedListener();
        this.modelChangedLstnr = this.initModelChangedListener();
        this.initListeningStrategy();
    }

    private final Table initTable(Table tableInstanceParam) {
        Table result = null;
        if (tableInstanceParam == null) {
            result = TableFactory.eINSTANCE.createTable();
            Resource newResource = ResourceUtils.createDefaultResource(this.editingDomain);
            newResource.getContents().add((Object)result);
        } else {
            result = tableInstanceParam;
        }
        return result;
    }

    private final Resource initResource() {
        Resource result = null;
        if (this.tableInstance.eResource() == null) {
            result = ResourceUtils.createDefaultResource(this.editingDomain);
            Command setResourceContentCommand = CommandFactory.createSetResourceContentsCommand((Resource)result, (EObject)this.tableInstance);
            if (setResourceContentCommand instanceof ILockableUndoCommand) {
                ILockableUndoCommand lockableUndoCommand = (ILockableUndoCommand)setResourceContentCommand;
                lockableUndoCommand.enableCanUndo(false);
            }
            this.editingDomain.getCommandStack().execute(setResourceContentCommand);
            result.getContents().add((Object)this.tableInstance);
        } else {
            result = this.tableInstance.eResource();
        }
        return result;
    }

    private void initListeningStrategy() {
        if (this.editingDomain instanceof TransactionalEditingDomain) {
            TransactionalEditingDomain transactionalEditingDomain = (TransactionalEditingDomain)this.editingDomain;
            RowDeleteTriggerListener listener = new RowDeleteTriggerListener(this.tableInstance);
            transactionalEditingDomain.addResourceSetListener((ResourceSetListener)listener);
        } else {
            RowDeleteCommandStackListener listener = new RowDeleteCommandStackListener(this.tableInstance, this.editingDomain);
            EditingDomainUtils.addCommandStackListener(this.editingDomain, listener);
        }
    }

    private final TableChangedListener initTableChangedListener() {
        return new TableChangedListener(this.tableInstance, new Runnable(){

            public void run() {
                TableWidget.this.refreshDelayed();
            }
        });
    }

    private final ModelChangedListener initModelChangedListener() {
        return new ModelChangedListener(this.tableInstance, new Runnable(){

            public void run() {
                TableWidget.this.refreshDelayed();
            }
        });
    }

    private final synchronized void reset() {
        boolean canReset = this.sortSrvc.isCanReset();
        if (canReset) {
            DebugUtils.debug((boolean)DEBUG_EVENTS, (String)"Start");
            this.metaClassCache.updateMetaClasses();
            this.tableLabelProvider = ICustomizedLabelProviderFactory.DEFAULT.createCustomizedLabelProvider(this.customizationEngine);
            FacetsUtils.loadManagedFacetSetsInTable(this.tableInstance, this.facetManager);
            if (this.tableInstance.getCustomizations() != null) {
                CustomizationUtils.loadCustomizationsInTable(this.tableInstance);
            }
            this.removeUselessRowsAndColumns();
            this.fullRedraw();
            DebugUtils.debug((boolean)DEBUG_EVENTS, (String)"End");
        }
    }

    protected final void onWidgetDisposed() {
        this.disposed = true;
        this.fSelectionChangedListeners.clear();
        this.modelChangedLstnr.dispose();
        this.tableChangedLstnr.dispose();
        this.refreshJob.cancel();
    }

    private static Object getStructuralFeatureValue(EObject eObject, EStructuralFeature structuralFeature) {
        return eObject.eGet(structuralFeature);
    }

    private static boolean hasStructuralFeature(EObject eObject, EStructuralFeature structuralFeature) {
        EClass eClass = eObject.eClass();
        return eClass.getEAllStructuralFeatures().contains((Object)structuralFeature);
    }

    public final void setSelection(ISelection selection) {
        this.selectionProvider.setSelection(selection);
    }

    public final void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionProvider.addSelectionChangedListener(listener);
    }

    public final void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionProvider.removeSelectionChangedListener(listener);
    }

    @Override
    public final void sortColumnsByType() {
        this.sortSrvc.sortColumnsByType();
    }

    @Override
    public final void setHideEmptyColumns(boolean hideEmptyColumns) {
        Command cmd = this.sortSrvc.getColumnsCmdFactory().createSetHideEmptyColumnsCommand(hideEmptyColumns);
        this.editingDomain.getCommandStack().execute(cmd);
    }

    @Override
    public final boolean isEmptyColumn(Column column) {
        FeatureColumn featureColumn;
        boolean result = false;
        if (column instanceof FeatureColumn && (featureColumn = (FeatureColumn)column).getFeature() instanceof EReference) {
            result = this.isEmpty((EStructuralFeature)((EReference)featureColumn.getFeature()));
        }
        return result;
    }

    @Override
    public final void selectColumnsToHide() {
        this.openColumnsToHideDialog();
    }

    @Override
    public final IColumnsToHideDialog openColumnsToHideDialog() {
        return this.columnsHideSrvc.openColumnsToHideDialog();
    }

    @Override
    public final void showHideColumns(List<Column> columnToShow, boolean putOnTheTop) {
        this.columnsHideSrvc.showHideColumns(columnToShow, putOnTheTop);
    }

    @Override
    public final boolean isOneOfTheLocalCustomizationsNotOnTheTop() {
        return CustomizationUtils.isOneOfTheLocalCustomizationsNotOnTheTop(this.tableInstance);
    }

    @Override
    public void putLocalCustomizationOnTheTop() {
        Command cmd = this.localCustoCmdFactory.createPutLocalCustomizationOnTheTopCommand();
        this.executeCommand(cmd);
    }

    private boolean isEmpty(EStructuralFeature reference) {
        for (EObject eObject : TableWidgetUtils.getElements(this.tableInstance)) {
            List list;
            if (!TableWidget.hasStructuralFeature(eObject, reference)) continue;
            Object value = TableWidget.getStructuralFeatureValue(eObject, reference);
            if (!(reference.isMany() && value instanceof List ? !(list = (List)value).isEmpty() : value != null)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void setOnlyShowCommonColumns(boolean onlyShowCommonColumns) {
        Command cmd = this.sortSrvc.getColumnsCmdFactory().createSetOnlyShowCommonColumnsCommand(onlyShowCommonColumns);
        this.executeCommand(cmd);
    }

    @Override
    public final boolean isColumnSelected() {
        return this.selectionService.isColumnSelected();
    }

    @Override
    public final void removeLine() {
        Collection<Row> rows = this.selectionService.getSelectedRow();
        Command cmd = this.tableCmdFactory.createRemoveRowsCommand(rows);
        this.executeCommand(cmd);
    }

    @Override
    public List<EObject> getSelectedRowEObjects() {
        return this.selectionService.getSelectedRowEObjects();
    }

    @Override
    public final void deleteSelection() {
        try {
            Set<EObject> selectedEObjects = this.selectionService.getSelectedEObjects();
            if (selectedEObjects != null && !selectedEObjects.isEmpty()) {
                Command cmd = this.tableCmdFactory.createDeleteSelectedElementsCommand(selectedEObjects);
                this.executeCommand(cmd);
            }
        }
        catch (CoreException e) {
            throw new TableWidgetRuntimeException(e);
        }
    }

    @Override
    public final List<InstantiationMethod> getInstantiationMethodHistory() {
        return this.initMethodSrvc.getInstantiationMethodHistory();
    }

    @Override
    public final void selectInstantiationMethodToLaunch() {
        this.initMethodSrvc.selectInstantiationMethodToLaunch();
    }

    @Override
    public final void createNewElement() {
        this.initMethodSrvc.createNewElement();
    }

    @Override
    public final void createNewElement(InstantiationMethod instantiationMethod) {
        this.initMethodSrvc.createNewElement(instantiationMethod);
    }

    @Override
    public final boolean isNonCommonColumns(Column column) {
        FeatureColumn featureColumn;
        boolean common = true;
        if (column instanceof FeatureColumn && (featureColumn = (FeatureColumn)column).getFeature() instanceof EStructuralFeature) {
            EStructuralFeature structuralFeature = (EStructuralFeature)featureColumn.getFeature();
            common = this.metaClassCache.isCommon(structuralFeature);
        }
        return !common;
    }

    @Override
    public final List<Column> getColumns() {
        return Collections.unmodifiableList(this.tableInstance.getColumns());
    }

    @Override
    public ICustomizationManager getCustomizationEngine() {
        return this.customizationEngine;
    }

    @Override
    public final IFacetManager getFacetContext() {
        return this.facetManager;
    }

    @Override
    public final void setFacetSets(List<? extends FacetSet> facetSets) {
        if (DEBUG_SET_FACET) {
            DebugUtils.debug((String)"nbFacetSets=", (Object[])new Object[]{String.valueOf(facetSets.size())});
            for (FacetSet facetSet : facetSets) {
                DebugUtils.debug((String)"facetSetName=", (Object[])new Object[]{facetSet.getName()});
            }
        }
        this.setLoadedFacetSets(new ArrayList<FacetSet>(facetSets));
        if (DEBUG_SET_FACET) {
            this.columnsHideSrvc.debugNbColumns();
        }
    }

    @Override
    public final TableConfiguration getTableConfiguration() {
        return this.getTable().getTableConfiguration();
    }

    @Override
    public final Table getTable() {
        return this.tableInstance;
    }

    public final EObject getContext() {
        return this.getTable().getContext();
    }

    @Override
    public final void addRows(List<? extends EObject> newElements) {
        Command cmd = this.tableCmdFactory.createAddRowsCommand(newElements);
        this.executeCommand(cmd);
    }

    @Override
    public final void openLoadCustomizationDialog() {
        this.facetAndCustomSrvc.openLoadCustomizationDialog();
    }

    @Override
    public final void openLoadFacetSetsDialog() {
        this.facetAndCustomSrvc.openLoadFacetSetsDialog();
    }

    protected Shell getShell() {
        return this.parent.getShell();
    }

    @Override
    public final void saveAs() {
        EditingDomainUtils.saveAs(this.editingDomain, this.resource);
    }

    @Override
    public final void save() {
        EditingDomainUtils.save(this.editingDomain, this.resource);
    }

    @Override
    public final boolean isDataEditable() {
        return this.dataEditable;
    }

    @Override
    public final void drop(IStructuredSelection structuredSelection, Object element, EStructuralFeature feature) {
        this.dropSrvc.drop(structuredSelection, element, feature);
    }

    @Override
    public void drop(IStructuredSelection structuredSelection) {
        this.dropSrvc.drop(structuredSelection);
    }

    @Override
    public final boolean canBeDropped(IStructuredSelection structuredSelection, Row row, Column column) {
        return this.dropSrvc.canBeDropped(structuredSelection, row, column);
    }

    @Override
    public final Control getComposite() {
        return this.composite.asComposite();
    }

    @Override
    public final void unregisterActionDelegate(IActionDelegate action) {
        this.actionList.remove(action);
    }

    @Override
    public final void notifyActions() {
        for (IActionDelegate action : this.actionList) {
            action.selectionChanged(null, null);
        }
    }

    @Override
    public final void sortColumnByNameAtoZ() {
        this.sortSrvc.sortColumnByNameAtoZ();
    }

    @Override
    public final void sortColumnByNameZtoA() {
        this.sortSrvc.sortColumnByNameZtoA();
    }

    @Override
    public final List<Column> getVisibleColumns(boolean setAtTheTop) {
        return this.columnsHideSrvc.getVisibleColumns(setAtTheTop);
    }

    @Override
    public final void putLocalCustomizationOnTheBottom() {
        Command cmd = this.localCustoCmdFactory.createPutLocalCustomizationOnTheBottomCommand();
        this.executeCommand(cmd);
    }

    @Override
    public final Row findRow(EObject eObject) {
        for (Row row : this.tableInstance.getRows()) {
            if (!row.getElement().equals(eObject)) continue;
            return row;
        }
        return null;
    }

    protected final void refreshDelayed() {
        DebugUtils.debug((boolean)DEBUG_RESOURCE_LISTENER);
        this.refreshJob.cancel();
        this.refreshJob.setPriority(50);
        this.refreshJob.schedule(100L);
    }

    @Override
    public final EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public final ICommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    @Override
    public final void waitForRefreshJob() {
        boolean wait = true;
        while (wait) {
            try {
                if (this.refreshJob != null) {
                    this.refreshJob.join();
                }
                wait = false;
            }
            catch (InterruptedException interruptedException) {
                wait = true;
            }
        }
    }

    private final void removeUselessRowsAndColumns() {
        Command cmd = this.tableCmdFactory.createRemoveUselessRowsAndColumnsCommand();
        this.executeCommand(cmd);
    }

    @Override
    public final boolean usesTmpResource() {
        return ResourceUtils.usesTmpResource((EObject)this.tableInstance);
    }

    @Override
    public final MenuManager getMenuManager() {
        return this.menuMgr;
    }

    @Override
    public ICustomizedLabelProvider getTableLabelProvider() {
        return this.tableLabelProvider;
    }

    @Override
    public void setColumnWidth(Column column, int width) {
        Command cmd = this.getCommandFactory().createSetCommand(this.getEditingDomain(), (Object)column, (Object)TablePackage.eINSTANCE.getColumn_Width(), (Object)width);
        this.getEditingDomain().getCommandStack().execute(cmd);
    }

    @Override
    public void setRowHeight(Row row, int height) {
        Command cmd = this.getCommandFactory().createSetCommand(this.getEditingDomain(), (Object)row, (Object)TablePackage.eINSTANCE.getRow_Height(), (Object)height);
        this.getEditingDomain().getCommandStack().execute(cmd);
    }

    @Override
    public void moveColumn(Column element, int newPosition) {
        Command command = this.getCommandFactory().createMoveCommand(this.getEditingDomain(), (Object)this.getTable(), (Object)TablePackage.eINSTANCE.getTable_Columns(), (Object)element, newPosition);
        this.getEditingDomain().getCommandStack().execute(command);
    }

    @Override
    public List<Column> getSelectedColumns() {
        return this.selectionService.getSelectedColumns();
    }

    @Override
    public void copySelectionToClipboard() {
        this.composite.copySelectionToClipboard();
    }

    @Override
    public void selectAll() {
        this.composite.selectAll();
    }

    @Override
    public boolean isCellSelected() {
        return !this.selectionProvider.getSelection().isEmpty();
    }

    @Override
    public void selectCell(EObject eObject, EStructuralFeature structuralFeature) {
        this.composite.selectCell(eObject, structuralFeature);
    }

    @Override
    public void editSelectedCell() {
        if (this.isSelectedCellEditable()) {
            this.composite.editSelectedCell();
        }
    }

    @Override
    public boolean isSelectedCellEditable() {
        return this.selectionService.isSelectedCellEditable();
    }

    @Override
    public void selectRows(List<EObject> elementsToSelect, boolean clearTheSelection) {
        this.composite.selectRows(elementsToSelect, clearTheSelection);
    }

    public ISelection getSelection() {
        return this.selectionProvider.getSelection();
    }

    private void checkNotDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("the widget is disposed");
        }
    }

    private void fullRedraw() {
        this.checkNotDisposed();
        this.composite.fullRedraw();
    }

    @Override
    public boolean getListenReorderEvent() {
        return this.sortSrvc.isListenReorderEvent();
    }

    @Override
    public final void loadCustomizations(List<Customization> customizationsToLoad, boolean mustLoadAdditionalFacets) {
        Command cmd = this.facetAndCustomSrvc.getFctCustCmdFactory().createSetCustomizationCommand(customizationsToLoad);
        this.executeCommand(cmd);
    }

    private void executeCommand(Command command) {
        EditingDomainUtils.executeCommand(command, this.editingDomain);
    }

    @Override
    public IContentPropertiesHandler getCustomPropertiesHandler() {
        return this.contentPropertiesHandler;
    }

    @Override
    public void setCanBePresentedInTheTable(ETypedElement presentabilityQuery, boolean removeNonConformingElements) {
        this.presentableSrvc.setCanBePresentedInTheTable(presentabilityQuery, removeNonConformingElements);
    }

    @Override
    public ETypedElement getCanBePresentedInTheTable() {
        return this.presentableSrvc.getPresentabilityQuery();
    }

    @Override
    public IAllowedContentsETypedElementSelectionDialog openCanBePresentedInTheTableDialog() {
        return this.presentableSrvc.openCanBePresentedInTheTableDialog(this.getShell());
    }

    @Override
    public List<ETypedElement> getApplicableCanBePresentedQueries() {
        return this.presentableSrvc.getApplicableCanBePresentedQueries();
    }

    @Override
    public void undo() {
        this.editingDomain.getCommandStack().undo();
    }

    @Override
    public void redo() {
        this.editingDomain.getCommandStack().redo();
    }

    @Override
    public void setLoadedFacetSets(List<FacetSet> facetSets) {
        Command cmd = this.facetAndCustomSrvc.getFctCustCmdFactory().createSetLoadedFacetSetsCommand(facetSets);
        this.executeCommand(cmd);
    }

    @Override
    public IETypedElementSelectionDialog<Object> openAddColumnsDialog() {
        return this.columnsAddSrvc.openAddColumnsDialog();
    }

    @Override
    public final void addColumns(List<ETypedElement> eTypedElements, List<FacetSet> facetSets) {
        this.columnsAddSrvc.addColumns(eTypedElements, facetSets);
    }

    @Override
    public void sortRows(Column column, ColumnSortDirection direction) {
        if (column instanceof FeatureColumn) {
            long begin = System.currentTimeMillis();
            FeatureColumn featureColumn = (FeatureColumn)column;
            Command cmd = this.tableCmdFactory.createSortRowCommand(featureColumn, direction, this.facetManager, this.customizationEngine);
            long createCmd = System.currentTimeMillis();
            this.executeCommand(cmd);
            long end = System.currentTimeMillis();
            if (DEBUG_SORT) {
                DebugUtils.debug((String)("sort and createCmd =" + (createCmd - begin)));
                DebugUtils.debug((String)("exec =" + (end - createCmd)));
                DebugUtils.debug((String)("total =" + (end - begin)));
            }
        }
    }

    @Override
    public List<Object> getRawSelection() {
        return this.selectionService.getRawSelection();
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void removeColumns(List<ETypedElement> elements) {
        Command cmd = this.sortSrvc.getColumnsCmdFactory().createRemoveColumnsCommand(elements);
        this.executeCommand(cmd);
    }

    @Override
    public ITableCommandFactory getTableCommandFactory() {
        return this.tableCmdFactory;
    }

    @Override
    public ISelectionPropertiesHandler getSelectionPropertiesHandler() {
        return this.selectionPropertiesHandler;
    }
}

