/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget.column;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.column.ColumnsCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.BasicCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.utils.EditingDomainUtils;

public class SortService {
    private boolean canReset;
    private boolean listenReorderEvnt;
    private final EditingDomain editingDomain;
    private final ColumnsCommandFactory columnsCmdFactory;

    public SortService(Table table, BasicCommandFactory basicCmdFactory) {
        this.editingDomain = basicCmdFactory.getEditingDomain();
        this.columnsCmdFactory = new ColumnsCommandFactory(table, basicCmdFactory);
        this.canReset = true;
        this.listenReorderEvnt = true;
    }

    public final void sortColumnsByType() {
        try {
            try {
                this.canReset = false;
                this.listenReorderEvnt = false;
                Command cmd = this.columnsCmdFactory.createSortColumnsByTypeCommand();
                EditingDomainUtils.executeCommand(cmd, this.editingDomain);
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (String)"Error sorting columns by type", (Plugin)Activator.getDefault());
                this.canReset = true;
                this.listenReorderEvnt = true;
            }
        }
        finally {
            this.canReset = true;
            this.listenReorderEvnt = true;
        }
    }

    public final void sortColumnByNameAtoZ() {
        try {
            try {
                this.canReset = false;
                this.listenReorderEvnt = false;
                Command cmd = this.columnsCmdFactory.createSortColumnByNameAtoZCommand();
                EditingDomainUtils.executeCommand(cmd, this.editingDomain);
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (String)"Error sorting columns by name From A to Z", (Plugin)Activator.getDefault());
                this.canReset = true;
                this.listenReorderEvnt = true;
            }
        }
        finally {
            this.canReset = true;
            this.listenReorderEvnt = true;
        }
    }

    public final void sortColumnByNameZtoA() {
        try {
            try {
                this.canReset = false;
                this.listenReorderEvnt = false;
                Command cmd = this.columnsCmdFactory.createSortColumnByNameZtoACommand();
                EditingDomainUtils.executeCommand(cmd, this.editingDomain);
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (String)"Error sorting columns by name from Z to A", (Plugin)Activator.getDefault());
                this.canReset = true;
                this.listenReorderEvnt = true;
            }
        }
        finally {
            this.canReset = true;
            this.listenReorderEvnt = true;
        }
    }

    public boolean isListenReorderEvent() {
        return this.listenReorderEvnt;
    }

    public boolean isCanReset() {
        return this.canReset;
    }

    public ColumnsCommandFactory getColumnsCmdFactory() {
        return this.columnsCmdFactory;
    }
}

