/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.edit.command.CommandActionDelegate;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StaticSelectionCommandAction
extends Action {
    private static final long serialVersionUID = 1L;
    protected EditingDomain editingDomain;
    protected Command command;

    public StaticSelectionCommandAction(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof IEditingDomainProvider) {
            this.editingDomain = ((IEditingDomainProvider)workbenchPart).getEditingDomain();
        }
    }

    public StaticSelectionCommandAction(IEditorPart editorPart) {
        this((IWorkbenchPart)editorPart);
    }

    public StaticSelectionCommandAction(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public StaticSelectionCommandAction() {
    }

    protected abstract Command createActionCommand(EditingDomain var1, Collection<?> var2);

    public void configureAction(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            this.disable();
        } else {
            IStructuredSelection sselection = (IStructuredSelection)selection;
            List list = sselection.toList();
            ArrayList collection = new ArrayList(list);
            if (this.editingDomain == null) {
                for (Object o : collection) {
                    this.editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor(o);
                    if (this.editingDomain != null) break;
                }
            }
            if (this.editingDomain != null) {
                this.command = this.createActionCommand(this.editingDomain, collection);
                this.setEnabled(this.command.canExecute());
            }
            if (this.command == null || this.command == UnexecutableCommand.INSTANCE) {
                this.disable();
            } else if (!(this.command instanceof CommandActionDelegate)) {
                if (this.getDefaultImageDescriptor() != null) {
                    this.setImageDescriptor(this.getDefaultImageDescriptor());
                }
            } else {
                CommandActionDelegate commandActionDelegate = (CommandActionDelegate)this.command;
                ImageDescriptor imageDescriptor = this.objectToImageDescriptor(commandActionDelegate.getImage());
                if (imageDescriptor != null) {
                    this.setImageDescriptor(imageDescriptor);
                } else if (this.getDefaultImageDescriptor() != null) {
                    this.setImageDescriptor(this.getDefaultImageDescriptor());
                }
                if (commandActionDelegate.getText() != null) {
                    this.setText(commandActionDelegate.getText());
                }
                if (commandActionDelegate.getDescription() != null) {
                    this.setDescription(commandActionDelegate.getDescription());
                }
                if (commandActionDelegate.getToolTipText() != null) {
                    this.setToolTipText(commandActionDelegate.getToolTipText());
                }
            }
        }
    }

    protected ImageDescriptor getDefaultImageDescriptor() {
        return null;
    }

    protected void disable() {
        this.setEnabled(false);
        if (this.getDefaultImageDescriptor() != null) {
            this.setImageDescriptor(this.getDefaultImageDescriptor());
        }
    }

    public void run() {
        if (this.editingDomain != null && this.command != null) {
            this.editingDomain.getCommandStack().execute(this.command);
        }
    }

    protected ImageDescriptor objectToImageDescriptor(Object object) {
        return ExtendedImageRegistry.getInstance().getImageDescriptor(object);
    }
}

