/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.Nullable;

public class StatusSwitch<T> {

    @Nullable
    public T doSwitch(@Nullable IStatus status) {
        if (status == null) {
            return null;
        }
        T res = caseStatus(status);
        if (res != null) {
            return res;
        }
        Throwable exception = status.getException();
        if (exception != null) {
            res = doSwitch(exception);
            if (res != null) {
                return res;
            }
        }
        for (IStatus child : status.getChildren()) {
            res = doSwitch(child);
            if (res != null) {
                return res;
            }
        }
        return res;
    }

    @Nullable
    public T doSwitch(Throwable exception) {
        if (exception == null) {
            return null;
        }
        T res = caseThrowable(exception);
        if (res != null) {
            return res;
        }
        for (StackTraceElement element : exception.getStackTrace()) {
            res = caseStackTraceElement(element);
            if (res != null) {
                return res;
            }
        }
        if (exception instanceof CoreException) {
            CoreException coreException = (CoreException) exception;
            IStatus innerStatus = coreException.getStatus();
            if (innerStatus != null) {
                res = doSwitch(innerStatus);
                if (res != null) {
                    return res;
                }
            }
        }

        Throwable cause = exception.getCause();
        if (cause != null) {
            res = doSwitch(cause);
            if (res != null) {
                return res;
            }
        }
        return res;
    }

    @Nullable
    public T caseStatus(IStatus status) {
        return null;
    }

    @Nullable
    public T caseThrowable(Throwable throwable) {
        return null;
    }

    @Nullable
    public T caseStackTraceElement(StackTraceElement stackTraceElement) {
        return null;
    }
}
