/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.utils;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.BiMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.logging.aeri.core.IModelPackage;
import org.eclipse.epp.logging.aeri.core.ISendOptions;
import org.eclipse.epp.logging.aeri.core.ISystemSettings;

public class Servers {
    private static BiMap<EAttribute, EAttribute> SYSTEM_TO_SERVER = HashBiMap.create((Map)ImmutableMap.of((Object)IModelPackage.Literals.USER_SETTINGS__REPORTER_NAME, (Object)IModelPackage.Literals.USER_SETTINGS__REPORTER_NAME, (Object)IModelPackage.Literals.USER_SETTINGS__REPORTER_EMAIL, (Object)IModelPackage.Literals.USER_SETTINGS__REPORTER_EMAIL, (Object)IModelPackage.Literals.USER_SETTINGS__ANONYMIZE_MESSAGES, (Object)IModelPackage.Literals.USER_SETTINGS__ANONYMIZE_MESSAGES, (Object)IModelPackage.Literals.USER_SETTINGS__ANONYMIZE_STACK_TRACES, (Object)IModelPackage.Literals.USER_SETTINGS__ANONYMIZE_STACK_TRACES));
    private static BiMap<EAttribute, EAttribute> SERVER_TO_SEND_OPTIONS = HashBiMap.create((Map)ImmutableMap.of((Object)IModelPackage.Literals.USER_SETTINGS__REPORTER_ID, (Object)IModelPackage.Literals.USER_SETTINGS__REPORTER_ID, (Object)IModelPackage.Literals.USER_SETTINGS__REPORTER_NAME, (Object)IModelPackage.Literals.USER_SETTINGS__REPORTER_NAME, (Object)IModelPackage.Literals.USER_SETTINGS__REPORTER_EMAIL, (Object)IModelPackage.Literals.USER_SETTINGS__REPORTER_EMAIL, (Object)IModelPackage.Literals.USER_SETTINGS__ANONYMIZE_MESSAGES, (Object)IModelPackage.Literals.USER_SETTINGS__ANONYMIZE_MESSAGES, (Object)IModelPackage.Literals.USER_SETTINGS__ANONYMIZE_STACK_TRACES, (Object)IModelPackage.Literals.USER_SETTINGS__ANONYMIZE_STACK_TRACES));
    private static BiMap<EAttribute, EAttribute> SYSTEM_TO_SEND_OPTIONS = HashBiMap.create((Map)ImmutableMap.of((Object)IModelPackage.Literals.USER_SETTINGS__REPORTER_ID, (Object)IModelPackage.Literals.USER_SETTINGS__REPORTER_ID, (Object)IModelPackage.Literals.USER_SETTINGS__REPORTER_NAME, (Object)IModelPackage.Literals.USER_SETTINGS__REPORTER_NAME, (Object)IModelPackage.Literals.USER_SETTINGS__REPORTER_EMAIL, (Object)IModelPackage.Literals.USER_SETTINGS__REPORTER_EMAIL, (Object)IModelPackage.Literals.USER_SETTINGS__ANONYMIZE_MESSAGES, (Object)IModelPackage.Literals.USER_SETTINGS__ANONYMIZE_MESSAGES, (Object)IModelPackage.Literals.USER_SETTINGS__ANONYMIZE_STACK_TRACES, (Object)IModelPackage.Literals.USER_SETTINGS__ANONYMIZE_STACK_TRACES));
    private static final Predicate<IServerDescriptor> CONFIGURED = new Predicate<IServerDescriptor>(){

        public boolean apply(IServerDescriptor input) {
            return input.isConfigured();
        }
    };
    private static final Predicate<IServerDescriptor> ENABLED = new Predicate<IServerDescriptor>(){

        public boolean apply(IServerDescriptor input) {
            return input.isEnabled();
        }
    };

    public static Collection<IServerDescriptor> viewOfConfigured(Collection<IServerDescriptor> unfiltered) {
        return Collections2.filter(unfiltered, CONFIGURED);
    }

    public static Collection<IServerDescriptor> viewOfUnconfigured(Collection<IServerDescriptor> unfiltered) {
        return Collections2.filter(unfiltered, (Predicate)Predicates.not(CONFIGURED));
    }

    public static Collection<IServerDescriptor> viewOfEnabled(Collection<IServerDescriptor> unfiltered) {
        return Collections2.filter(unfiltered, ENABLED);
    }

    public static Collection<IServerDescriptor> viewOfDisabled(Collection<IServerDescriptor> unfiltered) {
        return Collections2.filter(unfiltered, (Predicate)Predicates.not(ENABLED));
    }

    public static Collection<IServerDescriptor> viewOfActive(Collection<IServerDescriptor> unfiltered) {
        return Collections2.filter(unfiltered, (Predicate)Predicates.and(ENABLED, CONFIGURED));
    }

    public static Collection<IServerDescriptor> viewOfInactive(Collection<IServerDescriptor> unfiltered) {
        return Collections2.filter(unfiltered, (Predicate)Predicates.not((Predicate)Predicates.and(ENABLED, CONFIGURED)));
    }

    public static ImmutableList<IServerDescriptor> copyOfConfigured(Collection<IServerDescriptor> unfiltered) {
        return ImmutableList.copyOf(Servers.viewOfConfigured(unfiltered));
    }

    public static ImmutableList<IServerDescriptor> copyOfUnconfigured(Collection<IServerDescriptor> unfiltered) {
        return ImmutableList.copyOf(Servers.viewOfUnconfigured(unfiltered));
    }

    public static ImmutableList<IServerDescriptor> copyOfEnabled(Collection<IServerDescriptor> unfiltered) {
        return ImmutableList.copyOf(Servers.viewOfEnabled(unfiltered));
    }

    public static ImmutableList<IServerDescriptor> copyOfDisabled(Collection<IServerDescriptor> unfiltered) {
        return ImmutableList.copyOf(Servers.viewOfDisabled(unfiltered));
    }

    public static ImmutableList<IServerDescriptor> copyOfActive(Collection<IServerDescriptor> unfiltered) {
        return ImmutableList.copyOf(Servers.viewOfActive(unfiltered));
    }

    public static ImmutableList<IServerDescriptor> copyOfInactive(Collection<IServerDescriptor> unfiltered) {
        return ImmutableList.copyOf(Servers.viewOfInactive(unfiltered));
    }

    public static void copyServerDefaultsIfUnset(IServerDescriptor source, ISendOptions target) {
        Servers.copyIfUnset((EObject)source, (EObject)target, SERVER_TO_SEND_OPTIONS);
    }

    public static void copySystemDefaultsIfUnset(ISystemSettings source, ISendOptions target) {
        Servers.copyIfUnset((EObject)source, (EObject)target, SYSTEM_TO_SEND_OPTIONS);
    }

    public static void copySystemDefaultsIfUnset(ISystemSettings source, IServerDescriptor target) {
        Servers.copyIfUnset((EObject)source, (EObject)target, SYSTEM_TO_SERVER);
    }

    public static void setAsDefaults(IServerDescriptor source, ISystemSettings target) {
        Servers.copyIfUnset((EObject)source, (EObject)target, (Map<EAttribute, EAttribute>)SYSTEM_TO_SERVER.inverse());
    }

    public static List<IServerDescriptor> sort(Iterable<IServerDescriptor> servers) {
        return Ordering.from((Comparator)new Comparator<IServerDescriptor>(){

            @Override
            public int compare(IServerDescriptor o1, IServerDescriptor o2) {
                String id1 = o1.getId();
                String id2 = o2.getId();
                if (id1.startsWith("org.eclipse.epp.logging.aeri")) {
                    return -1;
                }
                if (id2.startsWith("org.eclipse.epp.logging.aeri")) {
                    return 1;
                }
                return id1.compareTo(id2);
            }
        }).sortedCopy(servers);
    }

    private static void copyIfUnset(EObject source, EObject target, Map<EAttribute, EAttribute> mappings) {
        for (Map.Entry<EAttribute, EAttribute> entry : mappings.entrySet()) {
            EAttribute toAttr = entry.getValue();
            if (target.eIsSet((EStructuralFeature)toAttr)) continue;
            EAttribute fromAttr = entry.getKey();
            Object value = source.eGet((EStructuralFeature)fromAttr);
            target.eSet((EStructuralFeature)toAttr, value);
        }
    }

    public static boolean isOnlyEclipseServer(Collection<IServerDescriptor> servers) {
        if (servers.isEmpty()) {
            return false;
        }
        for (IServerDescriptor server : servers) {
            if (StringUtils.startsWith((CharSequence)server.getId(), (CharSequence)"org.eclipse")) continue;
            return false;
        }
        return true;
    }
}

