/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientTransport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public abstract class RequestTemplate<T> {
    private HttpClientTransport transport;
    private ServiceReference<HttpClientTransport> transportReference;

    public RequestTemplate() {
    }

    protected RequestTemplate(HttpClientTransport transport) {
        this.transport = transport;
    }

    public String getUserAgent() {
        return HttpClientTransport.USER_AGENT;
    }

    public T execute(URI uri) throws ClientProtocolException, IOException {
        if (this.transport != null) {
            return this.executeImpl(uri);
        }
        try {
            this.acquireTransport();
            T t = this.executeImpl(uri);
            return t;
        }
        finally {
            this.releaseTransport();
        }
    }

    private void releaseTransport() {
        ServiceReference<HttpClientTransport> reference = this.transportReference;
        if (reference != null) {
            this.transport = null;
            this.transportReference = null;
            Bundle bundle = reference.getBundle();
            if (bundle != null) {
                bundle.getBundleContext().ungetService(reference);
            }
        }
    }

    private void acquireTransport() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        BundleContext bundleContext = bundle.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(HttpClientTransport.class);
        if (serviceReference == null) {
            throw new IllegalStateException();
        }
        HttpClientTransport transport = (HttpClientTransport)bundleContext.getService(serviceReference);
        if (transport == null) {
            throw new IllegalStateException();
        }
        this.transportReference = serviceReference;
        this.transport = transport;
    }

    protected T executeImpl(URI uri) throws ClientProtocolException, IOException {
        Request request = this.createRequest(uri);
        request = this.configureRequest(request, uri);
        Response response = this.transport.execute(request, uri);
        return this.handleResponse(response);
    }

    protected abstract Request createRequest(URI var1);

    protected Request configureRequest(Request request, URI uri) {
        request.setHeader("User-Agent", this.getUserAgent());
        return this.transport.configureRequest(request, uri);
    }

    protected T handleResponse(Response response) throws ClientProtocolException, IOException {
        return (T)response.handleResponse(response1 -> {
            T t;
            HttpEntity entity = null;
            try {
                StatusLine statusLine = response1.getStatusLine();
                entity = response1.getEntity();
                this.handleResponseStatus(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                t = this.handleResponseEntity(entity);
            }
            catch (Throwable throwable) {
                RequestTemplate.closeResponse(response1, entity);
                throw throwable;
            }
            RequestTemplate.closeResponse(response1, entity);
            return t;
        });
    }

    protected T handleResponseEntity(HttpEntity entity) throws IOException {
        if (entity == null) {
            return this.handleEmptyResponse();
        }
        Charset charset = null;
        ContentType contentType = ContentType.get((HttpEntity)entity);
        if (contentType != null) {
            charset = contentType.getCharset();
        }
        return this.handleResponseStream(entity.getContent(), charset);
    }

    protected abstract T handleResponseStream(InputStream var1, Charset var2) throws IOException;

    protected T handleEmptyResponse() {
        return null;
    }

    protected void handleResponseStatus(int statusCode, String reasonPhrase) throws IllegalStateException, IOException {
        if (statusCode >= 300) {
            if (statusCode == 404) {
                throw new FileNotFoundException(reasonPhrase);
            }
            throw new HttpResponseException(statusCode, reasonPhrase);
        }
    }

    private static void closeResponse(HttpResponse response, HttpEntity entity) throws IOException {
        if (entity != null) {
            EntityUtils.consumeQuietly((HttpEntity)entity);
        }
        if (response instanceof CloseableHttpResponse) {
            CloseableHttpResponse closeable = (CloseableHttpResponse)response;
            closeable.close();
        }
    }
}

